/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.junit.ArgumentsMutatorSeedSerializer;
import com.code_intelligence.jazzer.junit.AutofuzzSeedSerializer;
import com.code_intelligence.jazzer.junit.ByteArraySeedSerializer;
import com.code_intelligence.jazzer.junit.FuzzTestConfigurationError;
import com.code_intelligence.jazzer.junit.FuzzedDataProviderSeedSerializer;
import com.code_intelligence.jazzer.mutation.ArgumentsMutator;
import java.lang.reflect.Method;
import java.util.Optional;

interface SeedSerializer {
    public Object[] read(byte[] var1);

    public byte[] write(Object[] var1) throws UnsupportedOperationException;

    public static SeedSerializer of(Method method) {
        if (method.getParameterCount() == 0) {
            throw new FuzzTestConfigurationError("Methods annotated with @FuzzTest must take at least one parameter");
        }
        if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == byte[].class) {
            return new ByteArraySeedSerializer();
        }
        if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FuzzedDataProvider.class) {
            return new FuzzedDataProviderSeedSerializer();
        }
        Optional argumentsMutator = (Boolean)Opt.experimentalMutator.get() != false ? ArgumentsMutator.forMethod((Method)method) : Optional.empty();
        return argumentsMutator.map(ArgumentsMutatorSeedSerializer::new).orElseGet(() -> new AutofuzzSeedSerializer(method));
    }
}

