/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.SeedSerializer;
import com.code_intelligence.jazzer.junit.Utils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

class SeedArgumentsProvider
implements ArgumentsProvider {
    SeedArgumentsProvider() {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) throws IOException {
        if (Utils.runFromCommandLine(extensionContext)) {
            return Stream.empty();
        }
        Class testClass = extensionContext.getRequiredTestClass();
        Method testMethod = extensionContext.getRequiredTestMethod();
        Stream<Map.Entry<String, byte[]>> rawSeeds = Stream.of(new AbstractMap.SimpleImmutableEntry<String, byte[]>("<empty input>", new byte[0]));
        rawSeeds = Stream.concat(rawSeeds, this.walkInputs(testClass, testMethod));
        if (Utils.isCoverageAgentPresent() && Files.isDirectory(Utils.generatedCorpusPath(testClass, testMethod), new LinkOption[0])) {
            rawSeeds = Stream.concat(rawSeeds, SeedArgumentsProvider.walkInputsInPath(Utils.generatedCorpusPath(testClass, testMethod), Integer.MAX_VALUE));
        }
        SeedSerializer serializer = SeedSerializer.of(testMethod);
        return (Stream)rawSeeds.map(entry -> {
            Object[] args = serializer.read((byte[])entry.getValue());
            args[0] = Named.named((String)((String)entry.getKey()), (Object)args[0]);
            return Arguments.arguments((Object[])args);
        }).onClose(() -> {
            if (!Utils.isFuzzing(extensionContext)) {
                extensionContext.publishReportEntry("No fuzzing has been performed, the fuzz test has only been executed on the fixed set of inputs in the seed corpus.\nTo start fuzzing, run a test with the environment variable JAZZER_FUZZ set to a non-empty value.");
            }
        });
    }

    private Stream<Map.Entry<String, byte[]>> walkInputs(Class<?> testClass, Method testMethod) throws IOException {
        URI classInputsDirUri;
        URL classInputsDirUrl = testClass.getResource(Utils.inputsDirectoryResourcePath(testClass));
        if (classInputsDirUrl == null) {
            return Stream.empty();
        }
        try {
            classInputsDirUri = classInputsDirUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to open inputs resource directory: " + classInputsDirUrl, e);
        }
        if (classInputsDirUri.getScheme().equals("file")) {
            Path classInputsPath = Paths.get(classInputsDirUri);
            return Stream.concat(SeedArgumentsProvider.walkClassInputs(classInputsPath), SeedArgumentsProvider.walkTestInputs(classInputsPath, testMethod));
        }
        if (classInputsDirUri.getScheme().equals("jar")) {
            FileSystem jar = FileSystems.newFileSystem(classInputsDirUri, new HashMap());
            String pathInJar = classInputsDirUrl.getFile().substring(classInputsDirUrl.getFile().indexOf(33) + 1);
            Path classPathInJar = jar.getPath(pathInJar, new String[0]);
            return (Stream)Stream.concat(SeedArgumentsProvider.walkClassInputs(classPathInJar), SeedArgumentsProvider.walkTestInputs(classPathInJar, testMethod)).onClose(() -> {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        throw new IOException("Unsupported protocol for inputs resource directory: " + classInputsDirUrl);
    }

    private static Stream<Map.Entry<String, byte[]>> walkTestInputs(Path classInputsPath, Method testMethod) throws IOException {
        Path testInputsPath = classInputsPath.resolve(testMethod.getName());
        try {
            return SeedArgumentsProvider.walkInputsInPath(testInputsPath, Integer.MAX_VALUE);
        }
        catch (NoSuchFileException e) {
            return Stream.empty();
        }
    }

    private static Stream<Map.Entry<String, byte[]>> walkClassInputs(Path path) throws IOException {
        try {
            return SeedArgumentsProvider.walkInputsInPath(path, 1);
        }
        catch (NoSuchFileException e) {
            return Stream.empty();
        }
    }

    private static Stream<Map.Entry<String, byte[]>> walkInputsInPath(Path path, int depth) throws IOException {
        return Files.find(path, depth, (fileOrDir, basicFileAttributes) -> !basicFileAttributes.isDirectory(), FileVisitOption.FOLLOW_LINKS).sorted().map(file -> new AbstractMap.SimpleImmutableEntry<String, byte[]>(file.getFileName().toString(), SeedArgumentsProvider.readAllBytesUnchecked(file)));
    }

    private static byte[] readAllBytesUnchecked(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

