/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;

public final class CannedFuzzedDataProvider
implements FuzzedDataProvider {
    private final Iterator<Object> nextReply;

    public CannedFuzzedDataProvider(String can) {
        ArrayList recordedReplies;
        byte[] rawIn = Base64.getDecoder().decode(can);
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(rawIn);
             ObjectInputStream objectStream = new ObjectInputStream(byteStream);){
            recordedReplies = (ArrayList)objectStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.nextReply = recordedReplies.iterator();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static CannedFuzzedDataProvider create(List<Object> objects) {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            CannedFuzzedDataProvider cannedFuzzedDataProvider;
            try (ObjectOutputStream out = new ObjectOutputStream(bout);){
                out.writeObject(new ArrayList<Object>(objects));
                String base64 = Base64.getEncoder().encodeToString(bout.toByteArray());
                cannedFuzzedDataProvider = new CannedFuzzedDataProvider(base64);
            }
            return cannedFuzzedDataProvider;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean consumeBoolean() {
        return (Boolean)this.nextReply.next();
    }

    @Override
    public boolean[] consumeBooleans(int maxLength) {
        return (boolean[])this.nextReply.next();
    }

    @Override
    public byte consumeByte() {
        return (Byte)this.nextReply.next();
    }

    @Override
    public byte consumeByte(byte min, byte max) {
        return (Byte)this.nextReply.next();
    }

    @Override
    public short consumeShort() {
        return (Short)this.nextReply.next();
    }

    @Override
    public short consumeShort(short min, short max) {
        return (Short)this.nextReply.next();
    }

    @Override
    public short[] consumeShorts(int maxLength) {
        return (short[])this.nextReply.next();
    }

    @Override
    public int consumeInt() {
        return (Integer)this.nextReply.next();
    }

    @Override
    public int consumeInt(int min, int max) {
        return (Integer)this.nextReply.next();
    }

    @Override
    public int[] consumeInts(int maxLength) {
        return (int[])this.nextReply.next();
    }

    @Override
    public long consumeLong() {
        return (Long)this.nextReply.next();
    }

    @Override
    public long consumeLong(long min, long max) {
        return (Long)this.nextReply.next();
    }

    @Override
    public long[] consumeLongs(int maxLength) {
        return (long[])this.nextReply.next();
    }

    @Override
    public float consumeFloat() {
        return ((Float)this.nextReply.next()).floatValue();
    }

    @Override
    public float consumeRegularFloat() {
        return ((Float)this.nextReply.next()).floatValue();
    }

    @Override
    public float consumeRegularFloat(float min, float max) {
        return ((Float)this.nextReply.next()).floatValue();
    }

    @Override
    public float consumeProbabilityFloat() {
        return ((Float)this.nextReply.next()).floatValue();
    }

    @Override
    public double consumeDouble() {
        return (Double)this.nextReply.next();
    }

    @Override
    public double consumeRegularDouble(double min, double max) {
        return (Double)this.nextReply.next();
    }

    @Override
    public double consumeRegularDouble() {
        return (Double)this.nextReply.next();
    }

    @Override
    public double consumeProbabilityDouble() {
        return (Double)this.nextReply.next();
    }

    @Override
    public char consumeChar() {
        return ((Character)this.nextReply.next()).charValue();
    }

    @Override
    public char consumeChar(char min, char max) {
        return ((Character)this.nextReply.next()).charValue();
    }

    @Override
    public char consumeCharNoSurrogates() {
        return ((Character)this.nextReply.next()).charValue();
    }

    @Override
    public String consumeAsciiString(int maxLength) {
        return (String)this.nextReply.next();
    }

    @Override
    public String consumeString(int maxLength) {
        return (String)this.nextReply.next();
    }

    @Override
    public String consumeRemainingAsAsciiString() {
        return (String)this.nextReply.next();
    }

    @Override
    public String consumeRemainingAsString() {
        return (String)this.nextReply.next();
    }

    @Override
    public byte[] consumeBytes(int maxLength) {
        return (byte[])this.nextReply.next();
    }

    @Override
    public byte[] consumeRemainingAsBytes() {
        return (byte[])this.nextReply.next();
    }

    @Override
    public int remainingBytes() {
        return (Integer)this.nextReply.next();
    }
}

