/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty8;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class InstrumentedHandler
extends HandlerWrapper {
    private static final String PATCH = "PATCH";
    private final Timer dispatches;
    private final Meter requests;
    private final Meter resumes;
    private final Meter suspends;
    private final Meter expires;
    private final Counter activeRequests;
    private final Counter activeSuspendedRequests;
    private final Counter activeDispatches;
    private final Meter[] responses;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer patchRequests;
    private final Timer otherRequests;
    private final ContinuationListener listener;

    public InstrumentedHandler(MetricRegistry registry, Handler underlying) {
        this(registry, underlying, MetricRegistry.name(underlying.getClass(), (String[])new String[0]));
    }

    public InstrumentedHandler(MetricRegistry registry, Handler underlying, String prefix) {
        this.dispatches = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"dispatches"}));
        this.requests = registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"requests"}));
        this.resumes = registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"resumes"}));
        this.suspends = registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"suspends"}));
        this.expires = registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"expires"}));
        this.activeRequests = registry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-requests"}));
        this.activeSuspendedRequests = registry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-suspended-requests"}));
        this.activeDispatches = registry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-dispatches"}));
        this.responses = new Meter[]{registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"1xx-responses"})), registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"2xx-responses"})), registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"3xx-responses"})), registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"4xx-responses"})), registry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"5xx-responses"}))};
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-4xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getOneMinuteRate(), (double)InstrumentedHandler.this.requests.getOneMinuteRate());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-4xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getFiveMinuteRate(), (double)InstrumentedHandler.this.requests.getFiveMinuteRate());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-4xx-15m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[3].getFifteenMinuteRate(), (double)InstrumentedHandler.this.requests.getFifteenMinuteRate());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-5xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getOneMinuteRate(), (double)InstrumentedHandler.this.requests.getOneMinuteRate());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-5xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getFiveMinuteRate(), (double)InstrumentedHandler.this.requests.getFiveMinuteRate());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"percent-5xx-15m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedHandler.this.responses[4].getFifteenMinuteRate(), (double)InstrumentedHandler.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new ContinuationListener(){

            public void onComplete(Continuation continuation) {
                Request request = ((AsyncContinuation)continuation).getBaseRequest();
                InstrumentedHandler.this.updateResponses(request);
                if (!continuation.isResumed()) {
                    InstrumentedHandler.this.activeSuspendedRequests.dec();
                }
                InstrumentedHandler.this.expires.mark();
            }

            public void onTimeout(Continuation continuation) {
                Request request = ((AsyncContinuation)continuation).getBaseRequest();
                InstrumentedHandler.this.updateResponses(request);
                if (!continuation.isResumed()) {
                    InstrumentedHandler.this.activeSuspendedRequests.dec();
                }
            }
        };
        this.getRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"get-requests"}));
        this.postRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"post-requests"}));
        this.headRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"head-requests"}));
        this.putRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"put-requests"}));
        this.deleteRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"delete-requests"}));
        this.optionsRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"options-requests"}));
        this.traceRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"trace-requests"}));
        this.connectRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"connect-requests"}));
        this.patchRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"patch-requests"}));
        this.otherRequests = registry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"other-requests"}));
        this.setHandler(underlying);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        boolean isMilliseconds;
        long start;
        this.activeDispatches.inc();
        AsyncContinuation continuation = request.getAsyncContinuation();
        if (continuation.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            isMilliseconds = true;
        } else {
            this.activeSuspendedRequests.dec();
            if (continuation.isResumed()) {
                this.resumes.mark();
            }
            isMilliseconds = false;
            start = System.nanoTime();
        }
        try {
            super.handle(target, request, httpRequest, httpResponse);
        }
        finally {
            if (isMilliseconds) {
                long duration = System.currentTimeMillis() - start;
                this.dispatches.update(duration, TimeUnit.MILLISECONDS);
                this.requestTimer(request.getMethod()).update(duration, TimeUnit.MILLISECONDS);
            } else {
                long duration = System.nanoTime() - start;
                this.dispatches.update(duration, TimeUnit.NANOSECONDS);
                this.requestTimer(request.getMethod()).update(duration, TimeUnit.NANOSECONDS);
            }
            this.activeDispatches.dec();
            if (continuation.isSuspended()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(this.listener);
                }
                this.suspends.mark();
                this.activeSuspendedRequests.inc();
            } else if (continuation.isInitial()) {
                this.updateResponses(request);
            }
        }
    }

    private Timer requestTimer(String method) {
        if ("GET".equalsIgnoreCase(method)) {
            return this.getRequests;
        }
        if ("POST".equalsIgnoreCase(method)) {
            return this.postRequests;
        }
        if ("PUT".equalsIgnoreCase(method)) {
            return this.putRequests;
        }
        if ("HEAD".equalsIgnoreCase(method)) {
            return this.headRequests;
        }
        if ("DELETE".equalsIgnoreCase(method)) {
            return this.deleteRequests;
        }
        if ("OPTIONS".equalsIgnoreCase(method)) {
            return this.optionsRequests;
        }
        if ("TRACE".equalsIgnoreCase(method)) {
            return this.traceRequests;
        }
        if ("CONNECT".equalsIgnoreCase(method)) {
            return this.connectRequests;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return this.patchRequests;
        }
        return this.otherRequests;
    }

    private void updateResponses(Request request) {
        int response = request.getResponse().getStatus() / 100;
        if (response >= 1 && response <= 5) {
            this.responses[response - 1].mark();
        }
        this.activeRequests.dec();
        this.requests.mark();
    }
}

