/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty8;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class InstrumentedSslSocketConnector
extends SslSocketConnector {
    private final Timer duration;
    private final Meter accepts;
    private final Meter connects;
    private final Meter disconnects;
    private final Counter connections;
    private final Clock clock;

    public InstrumentedSslSocketConnector(MetricRegistry registry, int port, SslContextFactory factory, Clock clock) {
        super(factory);
        this.clock = clock;
        this.setPort(port);
        this.duration = registry.timer(MetricRegistry.name(SslSocketConnector.class, (String[])new String[]{Integer.toString(port), "connection-duration"}));
        this.accepts = registry.meter(MetricRegistry.name(SslSocketConnector.class, (String[])new String[]{Integer.toString(port), "accepts"}));
        this.connects = registry.meter(MetricRegistry.name(SslSocketConnector.class, (String[])new String[]{Integer.toString(port), "connects"}));
        this.disconnects = registry.meter(MetricRegistry.name(SslSocketConnector.class, (String[])new String[]{Integer.toString(port), "disconnects"}));
        this.connections = registry.counter(MetricRegistry.name(SslSocketConnector.class, (String[])new String[]{Integer.toString(port), "active-connections"}));
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        super.accept(acceptorID);
        this.accepts.mark();
    }

    protected void connectionOpened(Connection connection) {
        this.connections.inc();
        super.connectionOpened(connection);
        this.connects.mark();
    }

    protected void connectionClosed(Connection connection) {
        super.connectionClosed(connection);
        this.disconnects.mark();
        long duration = this.clock.getTime() - connection.getTimeStamp();
        this.duration.update(duration, TimeUnit.MILLISECONDS);
        this.connections.dec();
    }
}

