/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.ehcache;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

public class InstrumentedEhcache
extends EhcacheDecoratorAdapter {
    private final Timer getTimer;
    private final Timer putTimer;

    public static Ehcache instrument(MetricRegistry registry, final Ehcache cache) {
        cache.setSampledStatisticsEnabled(true);
        cache.setStatisticsAccuracy(0);
        String prefix = MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName()});
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"hits"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getCacheHits();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-hits"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getInMemoryHits();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-hits"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getOffHeapHits();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-hits"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getOnDiskHits();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"misses"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getCacheMisses();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-misses"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getInMemoryMisses();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-misses"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getOffHeapMisses();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-misses"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getOnDiskMisses();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"objects"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getObjectCount();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-objects"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getMemoryStoreObjectCount();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-objects"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getOffHeapStoreObjectCount();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-objects"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getDiskStoreObjectCount();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"mean-get-time"}), (Metric)new Gauge<Float>(){

            public Float getValue() {
                return Float.valueOf(cache.getStatistics().getAverageGetTime());
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"mean-search-time"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getAverageSearchTime();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"eviction-count"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getEvictionCount();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"searches-per-second"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getSearchesPerSecond();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"writer-queue-size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.getStatistics().getWriterQueueSize();
            }
        });
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"accuracy"}), (Metric)new Gauge<String>(){

            public String getValue() {
                return cache.getStatistics().getStatisticsAccuracyDescription();
            }
        });
        return new InstrumentedEhcache(registry, cache);
    }

    private InstrumentedEhcache(MetricRegistry registry, Ehcache cache) {
        super(cache);
        this.getTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "gets"}));
        this.putTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "puts"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element, doNotNotifyCacheReplicators);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        Timer.Context ctx = this.putTimer.time();
        try {
            Element element2 = this.underlyingCache.putIfAbsent(element);
            return element2;
        }
        finally {
            ctx.stop();
        }
    }
}

