/*
 * Decompiled with CFR 0.152.
 */
package com.cncoderx.wheelview;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import com.cncoderx.wheelview.WheelView;

public class Wheel3DView
extends WheelView {
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();

    public Wheel3DView(Context context) {
        this(context, null);
    }

    public Wheel3DView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getPrefWidth() {
        int prefWidth = super.getPrefWidth();
        int innerHeight = (int)((double)(this.itemHeight * this.getVisibleItems() * 2) / Math.PI);
        int towardRange = (int)(Math.sin(0.06544984694978735) * (double)innerHeight);
        return prefWidth += towardRange;
    }

    @Override
    public int getPrefHeight() {
        int padding = this.getPaddingTop() + this.getPaddingBottom();
        int innerHeight = (int)((double)(this.itemHeight * this.getVisibleItems() * 2) / Math.PI);
        return innerHeight + padding;
    }

    @Override
    protected void calcVisibleItems() {
        int innerHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int items = (int)((double)innerHeight * Math.PI / (double)this.itemHeight / 2.0);
        this.setVisibleItems(items);
    }

    @Override
    protected void drawItem(Canvas canvas, int index, int offset) {
        CharSequence text = this.getCharSequence(index);
        if (text == null) {
            return;
        }
        int r = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        int range = (index - this.mScroller.getItemIndex()) * this.itemHeight - offset;
        if ((double)Math.abs(range) > (double)r * Math.PI / 2.0) {
            return;
        }
        double angle = (double)range / (double)r;
        float rotate = (float)Math.toDegrees(-angle);
        float translateY = (float)(Math.sin(angle) * (double)r);
        float translateZ = (float)((1.0 - Math.cos(angle)) * (double)r);
        float refractX = (float)this.getTextSize() * 0.05f;
        int alpha = (int)(Math.cos(angle) * 255.0);
        int clipLeft = this.getPaddingLeft();
        int clipRight = this.getWidth() - this.getPaddingRight();
        int clipTop = this.getPaddingTop();
        int clipBottom = this.getHeight() - this.getPaddingBottom();
        if (Math.abs(range) <= 0) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
        } else if (range > 0 && range < this.itemHeight) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
            this.mPaint.setColor(this.getUnselectedColor());
            this.mPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(clipLeft, this.lowerLimit, clipRight, clipBottom);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
        } else if (range < 0 && range > -this.itemHeight) {
            this.mPaint.setColor(this.getSelectedColor());
            canvas.save();
            canvas.translate(refractX, 0.0f);
            canvas.clipRect(clipLeft, this.upperLimit, clipRight, this.lowerLimit);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
            this.mPaint.setColor(this.getUnselectedColor());
            this.mPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, this.upperLimit);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
        } else {
            this.mPaint.setColor(this.getUnselectedColor());
            this.mPaint.setAlpha(alpha);
            canvas.save();
            canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
            this.drawText(canvas, text, 0.0f, translateY, translateZ, rotate);
            canvas.restore();
        }
    }

    private void drawText(Canvas canvas, CharSequence text, float translateX, float translateY, float translateZ, float rotateX) {
        this.mCamera.save();
        this.mCamera.translate(translateX, 0.0f, translateZ);
        this.mCamera.rotateX(rotateX);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        float x = this.centerX;
        float y = (float)this.centerY + translateY;
        this.mMatrix.preTranslate(-x, -y);
        this.mMatrix.postTranslate(x, y);
        canvas.concat(this.mMatrix);
        canvas.drawText(text, 0, text.length(), x, y - (float)this.baseline, this.mPaint);
    }
}

