/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.DateTimeUtil;
import com.cloudhopper.commons.util.FileAlreadyExistsException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class FileUtil {
    private FileUtil() {
    }

    private static boolean equals(InputStream is1, InputStream is2) throws IOException {
        int BUFFSIZE = 1024;
        byte[] buf1 = new byte[BUFFSIZE];
        byte[] buf2 = new byte[BUFFSIZE];
        if (is1 == is2) {
            return true;
        }
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return false;
        }
        int read1 = -1;
        int read2 = -1;
        do {
            int offset2;
            int offset1;
            for (offset1 = 0; offset1 < BUFFSIZE && (read1 = is1.read(buf1, offset1, BUFFSIZE - offset1)) >= 0; offset1 += read1) {
            }
            for (offset2 = 0; offset2 < BUFFSIZE && (read2 = is2.read(buf2, offset2, BUFFSIZE - offset2)) >= 0; offset2 += read2) {
            }
            if (offset1 != offset2) {
                return false;
            }
            if (offset1 != BUFFSIZE) {
                Arrays.fill(buf1, offset1, BUFFSIZE, (byte)0);
                Arrays.fill(buf2, offset2, BUFFSIZE, (byte)0);
            }
            if (Arrays.equals(buf1, buf2)) continue;
            return false;
        } while (read1 >= 0 && read2 >= 0);
        return read1 < 0 && read2 < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream is1 = null;
        InputStream is2 = null;
        try {
            is1 = new FileInputStream(file1);
            is2 = new FileInputStream(file2);
            boolean bl = FileUtil.equals(is1, is2);
            return bl;
        }
        finally {
            if (is1 != null) {
                try {
                    ((InputStream)is1).close();
                }
                catch (Exception exception) {}
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isValidFileExtension(String extension) {
        for (int i = 0; i < extension.length(); ++i) {
            char c = extension.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static String parseFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int pos = filename.lastIndexOf(46);
        if (pos < 0 || pos + 1 >= filename.length()) {
            return null;
        }
        return filename.substring(pos + 1);
    }

    public static File[] findFiles(File dir, FileFilter filter) throws FileNotFoundException {
        if (!dir.exists()) {
            throw new FileNotFoundException("Directory " + dir + " does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("File " + dir + " is not a directory.");
        }
        ArrayList<File> files = new ArrayList<File>();
        File[] allFiles = dir.listFiles();
        if (allFiles != null && allFiles.length > 0) {
            for (File f : allFiles) {
                if (!f.isFile() || !filter.accept(f)) continue;
                files.add(f);
            }
        }
        Object[] r = files.toArray(new File[0]);
        Arrays.sort(r);
        return r;
    }

    public static void copy(File sourceFile, File targetFile) throws FileAlreadyExistsException, IOException {
        FileUtil.copy(sourceFile, targetFile, false);
    }

    public static boolean copy(File sourceFile, File targetFile, boolean overwrite) throws FileAlreadyExistsException, IOException {
        boolean overwriteOccurred = false;
        if (targetFile.exists()) {
            if (!overwrite) {
                throw new FileAlreadyExistsException("Target file " + targetFile + " already exists");
            }
            overwriteOccurred = true;
        }
        FileInputStream fis = new FileInputStream(sourceFile);
        FileOutputStream fos = new FileOutputStream(targetFile);
        fis.getChannel().transferTo(0L, sourceFile.length(), fos.getChannel());
        fis.close();
        fos.flush();
        fos.close();
        return overwriteOccurred;
    }

    public static class FileNameDateTimeComparator
    implements Comparator<File> {
        private String pattern;
        private DateTimeZone zone;

        public FileNameDateTimeComparator() {
            this(null, null);
        }

        public FileNameDateTimeComparator(String pattern, DateTimeZone zone) {
            this.pattern = pattern == null ? "yyyy-MM-dd" : pattern;
            this.zone = zone == null ? DateTimeZone.UTC : zone;
        }

        @Override
        public int compare(File f1, File f2) {
            DateTime dt1 = DateTimeUtil.parseEmbedded(f1.getName(), this.pattern, this.zone);
            DateTime dt2 = DateTimeUtil.parseEmbedded(f2.getName(), this.pattern, this.zone);
            return dt1.compareTo((ReadableInstant)dt2);
        }
    }
}

