/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Ticket;

@JsonIgnoreProperties(value={"comment"}, ignoreUnknown=true)
public class TicketImport
extends Ticket {
    private static final long serialVersionUID = 1L;
    private List<Comment> comments;
    private Date solvedAt;

    public TicketImport() {
    }

    public TicketImport(Ticket.Requester requester, String subject, List<Comment> comments) {
        super(requester, subject, null);
        this.comments = comments;
    }

    public TicketImport(long requesterId, String subject, List<Comment> comments) {
        super(requesterId, subject, null);
        this.comments = comments;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @JsonProperty(value="solved_at")
    public Date getSolvedAt() {
        return this.solvedAt;
    }

    public void setSolvedAt(Date solvedAt) {
        this.solvedAt = solvedAt;
    }

    @Override
    public Comment getComment() {
        return null;
    }

    @Override
    public void setComment(Comment comment) {
        String msg = "single comment is not supported for ticket import, include in comments list instead";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ticket");
        sb.append("{assigneeId=").append(this.getAssigneeId());
        sb.append(", id=").append(this.getId());
        sb.append(", url='").append(this.getUrl()).append('\'');
        sb.append(", externalId='").append(this.getExternalId()).append('\'');
        sb.append(", type='").append((Object)this.getType()).append('\'');
        sb.append(", subject='").append(this.getSubject()).append('\'');
        sb.append(", description='").append(this.getDescription()).append('\'');
        sb.append(", priority='").append((Object)this.getPriority()).append('\'');
        sb.append(", status='").append((Object)this.getStatus()).append('\'');
        sb.append(", recipient='").append(this.getRecipient()).append('\'');
        sb.append(", requesterId=").append(this.getRequesterId());
        sb.append(", submitterId=").append(this.getSubmitterId());
        sb.append(", organizationId=").append(this.getOrganizationId());
        sb.append(", groupId=").append(this.getGroupId());
        sb.append(", collaboratorIds=").append(this.getCollaboratorIds());
        sb.append(", forumTopicId=").append(this.getForumTopicId());
        sb.append(", problemId=").append(this.getProblemId());
        sb.append(", hasIncidents=").append(this.isHasIncidents());
        sb.append(", dueAt=").append(this.getDueAt());
        sb.append(", tags=").append(this.getTags());
        sb.append(", via=").append(this.getVia());
        sb.append(", customFields=").append(this.getCustomFields());
        sb.append(", satisfactionRating=").append(this.getSatisfactionRating());
        sb.append(", sharingAgreementIds=").append(this.getSharingAgreementIds());
        sb.append(", followupIds=").append(this.getFollowupIds());
        sb.append(", ticketFormId=").append(this.getTicketFormId());
        sb.append(", brandId=").append(this.getBrandId());
        sb.append(", solvedAt=").append(this.getSolvedAt());
        sb.append(", updatedAt=").append(this.getUpdatedAt());
        sb.append(", solvedAt=").append(this.solvedAt);
        sb.append(", comments=").append(this.comments);
        sb.append('}');
        return sb.toString();
    }
}

