/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.zendesk.client.v2.model.CustomFieldValue;
import org.zendesk.client.v2.model.Priority;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.Status;
import org.zendesk.client.v2.model.Type;
import org.zendesk.client.v2.model.Via;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Ticket {
    private Integer id;
    private String url;
    private String externalId;
    private Type type;
    private String subject;
    private String description;
    private Comment comment;
    private Priority priority;
    private Status status;
    private String recipient;
    private Requester requester;
    private Integer requesterId;
    private Integer submitterId;
    private Integer assigneeId;
    private Integer organizationId;
    private Integer groupId;
    private List<Integer> collaboratorIds;
    private Integer forumTopicId;
    private Integer problemId;
    private boolean hasIncidents;
    private Date dueAt;
    private List<String> tags;
    private Via via;
    private List<CustomFieldValue> customFields;
    private SatisfactionRating satisfactionRating;
    private List<Integer> sharingAgreementIds;
    private List<Integer> followupIds;
    private Integer ticketFormId;
    private Date createdAt;
    private Date updatedAt;

    public Ticket() {
    }

    public Ticket(Requester requester, String subject, Comment comment) {
        this.subject = subject;
        this.requester = requester;
        this.comment = comment;
    }

    public Ticket(int requesterId, String subject, Comment comment) {
        this.subject = subject;
        this.requesterId = requesterId;
        this.comment = comment;
    }

    @JsonProperty(value="assignee_id")
    public Integer getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Integer assigneeId) {
        this.assigneeId = assigneeId;
    }

    @JsonProperty(value="collaborator_ids")
    public List<Integer> getCollaboratorIds() {
        return this.collaboratorIds;
    }

    public void setCollaboratorIds(List<Integer> collaboratorIds) {
        this.collaboratorIds = collaboratorIds;
    }

    @JsonProperty(value="created_at")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="custom_fields")
    public List<CustomFieldValue> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<CustomFieldValue> customFields) {
        this.customFields = customFields;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="due_at")
    public Date getDueAt() {
        return this.dueAt;
    }

    public void setDueAt(Date dueAt) {
        this.dueAt = dueAt;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="followup_ids")
    public List<Integer> getFollowupIds() {
        return this.followupIds;
    }

    public void setFollowupIds(List<Integer> followupIds) {
        this.followupIds = followupIds;
    }

    @JsonProperty(value="forum_topic_id")
    public Integer getForumTopicId() {
        return this.forumTopicId;
    }

    public void setForumTopicId(Integer forumTopicId) {
        this.forumTopicId = forumTopicId;
    }

    @JsonProperty(value="group_id")
    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    @JsonProperty(value="has_incidents")
    public boolean isHasIncidents() {
        return this.hasIncidents;
    }

    public void setHasIncidents(boolean hasIncidents) {
        this.hasIncidents = hasIncidents;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="organization_id")
    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @JsonProperty(value="problem_id")
    public Integer getProblemId() {
        return this.problemId;
    }

    public void setProblemId(Integer problemId) {
        this.problemId = problemId;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public void setRequester(Requester requester) {
        this.requester = requester;
        if (requester != null) {
            this.requesterId = null;
        }
    }

    @JsonProperty(value="requester_id")
    public Integer getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(Integer requesterId) {
        this.requesterId = requesterId;
        if (requesterId != null) {
            this.requester = null;
        }
    }

    @JsonProperty(value="satisfaction_rating")
    public SatisfactionRating getSatisfactionRating() {
        return this.satisfactionRating;
    }

    public void setSatisfactionRating(SatisfactionRating satisfactionRating) {
        this.satisfactionRating = satisfactionRating;
    }

    @JsonProperty(value="sharing_agreement_ids")
    public List<Integer> getSharingAgreementIds() {
        return this.sharingAgreementIds;
    }

    public void setSharingAgreementIds(List<Integer> sharingAgreementIds) {
        this.sharingAgreementIds = sharingAgreementIds;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="submitter_id")
    public Integer getSubmitterId() {
        return this.submitterId;
    }

    public void setSubmitterId(Integer submitterId) {
        this.submitterId = submitterId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="ticket_form_id")
    public Integer getTicketFormId() {
        return this.ticketFormId;
    }

    public void setTicketFormId(Integer ticketFormId) {
        this.ticketFormId = ticketFormId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="updated_at")
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Via getVia() {
        return this.via;
    }

    public void setVia(Via via) {
        this.via = via;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ticket");
        sb.append("{assigneeId=").append(this.assigneeId);
        sb.append(", id=").append(this.id);
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", externalId='").append(this.externalId).append('\'');
        sb.append(", type='").append((Object)this.type).append('\'');
        sb.append(", subject='").append(this.subject).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", priority='").append((Object)this.priority).append('\'');
        sb.append(", status='").append((Object)this.status).append('\'');
        sb.append(", recipient='").append(this.recipient).append('\'');
        sb.append(", requesterId=").append(this.requesterId);
        sb.append(", submitterId=").append(this.submitterId);
        sb.append(", organizationId=").append(this.organizationId);
        sb.append(", groupId=").append(this.groupId);
        sb.append(", collaboratorIds=").append(this.collaboratorIds);
        sb.append(", forumTopicId=").append(this.forumTopicId);
        sb.append(", problemId=").append(this.problemId);
        sb.append(", hasIncidents=").append(this.hasIncidents);
        sb.append(", dueAt=").append(this.dueAt);
        sb.append(", tags=").append(this.tags);
        sb.append(", via=").append(this.via);
        sb.append(", customFields=").append(this.customFields);
        sb.append(", satisfactionRating=").append(this.satisfactionRating);
        sb.append(", sharingAgreementIds=").append(this.sharingAgreementIds);
        sb.append(", followupIds=").append(this.followupIds);
        sb.append(", ticketFormId=").append(this.ticketFormId);
        sb.append(", createdAt=").append(this.createdAt);
        sb.append(", updatedAt=").append(this.updatedAt);
        sb.append('}');
        return sb.toString();
    }

    public static class Requester {
        private Integer localeId;
        private String name;
        private String email;

        public Requester() {
        }

        public Requester(String email) {
            this.email = email;
        }

        public Requester(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public Requester(Integer localeId, String name, String email) {
            this.localeId = localeId;
            this.name = name;
            this.email = email;
        }

        @JsonProperty(value="locale_id")
        public Integer getLocaleId() {
            return this.localeId;
        }

        public void setLocaleId(Integer localeId) {
            this.localeId = localeId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Requester");
            sb.append("{localeId=").append(this.localeId);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", email='").append(this.email).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comment {
        private String body;
        private List<String> uploads;

        public Comment() {
        }

        public Comment(String body) {
            this.body = body;
        }

        public Comment(String body, String ... uploads) {
            this.body = body;
            this.uploads = uploads.length == 0 ? null : Arrays.asList(uploads);
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public List<String> getUploads() {
            return this.uploads;
        }

        public void setUploads(List<String> uploads) {
            this.uploads = uploads;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Comment");
            sb.append("{body='").append(this.body).append('\'');
            sb.append(", uploads=").append(this.uploads);
            sb.append('}');
            return sb.toString();
        }
    }
}

