/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.xpdev;

import com.cloudbees.jenkins.plugins.xpdev.WebHookCause;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.GitSCM;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.security.ACL;
import hudson.util.IOUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class WebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(WebHook.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "xpdev-webhook";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIndex(StaplerRequest req) throws IOException {
        String payload = IOUtils.toString((Reader)req.getReader());
        LOGGER.fine("Full details of the POST was " + payload);
        JSONObject o = JSONObject.fromObject((Object)payload);
        String repoUrl = o.getString("repository_ssl_path");
        LOGGER.info("Received POST for " + repoUrl);
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            for (AbstractProject job : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                boolean found = false;
                SCM scm = job.getScm();
                if (scm instanceof SubversionSCM) {
                    found = this.hasRepository(repoUrl, (SubversionSCM)scm);
                } else if (scm instanceof GitSCM) {
                    found = this.hasRepository(repoUrl, (GitSCM)scm);
                } else if (scm instanceof MercurialSCM) {
                    found = this.hasRepository(repoUrl, (MercurialSCM)scm);
                }
                if (found) {
                    LOGGER.info(job.getFullDisplayName() + " triggered by web hook.");
                    job.scheduleBuild((Cause)new WebHookCause());
                }
                LOGGER.fine("Skipped " + job.getFullDisplayName() + " because it doesn't have a matching repository.");
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    private boolean hasRepository(String repoUrl, SubversionSCM scm) {
        for (SubversionSCM.ModuleLocation location : scm.getLocations()) {
            if (!location.getURL().equals(repoUrl)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepository(String repoUrl, GitSCM scm) {
        for (RemoteConfig remote : scm.getRepositories()) {
            for (URIish uri : remote.getURIs()) {
                if (!uri.toString().equals(repoUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRepository(String repoUrl, MercurialSCM scm) {
        return scm.getSource().equals(repoUrl);
    }
}

