/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.datapipe.jenkins.vault.credentials.VaultGithubTokenCredential;
import hudson.util.Secret;
import java.util.Optional;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"hashicorp-vault-plugin"})
public class VaultGitHubTokenCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "vaultGitHubToken".equals(type);
    }

    public VaultGithubTokenCredential convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "vaultGitHubToken definition contains no data");
        String accessTokenBase64 = SecretUtils.getNonNullSecretData(secret, "accessToken", "vaultGitHubToken credential is missing the accessToken");
        Optional<String> mountPathBase64 = SecretUtils.getOptionalSecretData(secret, "mountPath", "vaultGitHubToken credential is missing the mountPath");
        Optional<String> namespaceBase64 = SecretUtils.getOptionalSecretData(secret, "namespace", "vaultGitHubToken credential is missing the namespace");
        String accessToken = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(accessTokenBase64), "vaultGitHubToken credential has an invalid accessToken (must be base64 encoded UTF-8)");
        VaultGithubTokenCredential cred = new VaultGithubTokenCredential(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), Secret.fromString((String)accessToken));
        if (mountPathBase64.isPresent()) {
            String mountPath = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(mountPathBase64.get()), "vaultGitHubToken credential has an invalid mountPath (must be base64 encoded UTF-8)");
            cred.setMountPath(mountPath);
        }
        if (namespaceBase64.isPresent()) {
            String namespace = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(namespaceBase64.get()), "vaultGitHubToken credential has an invalid namespace (must be base64 encoded UTF-8)");
            cred.setNamespace(namespace);
        }
        return cred;
    }
}

