/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Secret;

@Extension
public class UsernamePasswordCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "usernamePassword".equals(type);
    }

    public UsernamePasswordCredentialsImpl convert(Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "usernamePassword definition contains no data");
        String usernameBase64 = SecretUtils.getNonNullSecretData(secret, "username", "usernamePassword credential is missing the username");
        String passwordBase64 = SecretUtils.getNonNullSecretData(secret, "password", "usernamePassword credential is missing the password");
        String username = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(usernameBase64), "usernamePassword credential has an invalid username (must be base64 encoded UTF-8)");
        String password = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(passwordBase64), "usernamePassword credential has an invalid password (must be base64 encoded UTF-8)");
        return new UsernamePasswordCredentialsImpl(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), username, password);
    }
}

