/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.SecretBytes;
import io.fabric8.kubernetes.api.model.Secret;
import org.jenkinsci.plugins.plaincredentials.impl.FileCredentialsImpl;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"plain-credentials"})
public class FileCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "secretFile".equals(type);
    }

    public FileCredentialsImpl convert(Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "secretFile definition contains no data");
        String filenameBase64 = SecretUtils.getNonNullSecretData(secret, "filename", "secretFile credential is missing the filename");
        String dataBase64 = SecretUtils.getNonNullSecretData(secret, "data", "secretFile credential is missing the data");
        String filename = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(filenameBase64), "secretFile credential has an invalid filename (must be base64 encoded UTF-8)");
        byte[] _data = SecretUtils.requireNonNull(SecretUtils.base64Decode(dataBase64), "secretFile credential has an invalid data (must be base64 encoded data)");
        SecretBytes sb = SecretBytes.fromBytes((byte[])_data);
        return new FileCredentialsImpl(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), filename, sb);
    }
}

