/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Secret;
import java.security.KeyStoreException;

@Extension
public class CertificateCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "certificate".equals(type);
    }

    public CertificateCredentialsImpl convert(Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "certificate definition contains no data");
        String passwordBase64 = SecretUtils.getNonNullSecretData(secret, "password", "certificate credential is missing the password entry");
        String password = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(passwordBase64), "certificate credential has an invalid password (must be base64 encoded UTF-8)");
        String certBase64 = SecretUtils.getNonNullSecretData(secret, "certificate", "certificate credential is missing the certificate entry");
        byte[] certData = SecretUtils.requireNonNull(SecretUtils.base64Decode(certBase64), "certificate credential has an invalid certificate (must be base64 encoded data)");
        SecretBytes sb = SecretBytes.fromBytes((byte[])certData);
        CertificateCredentialsImpl certificateCredentialsImpl = new CertificateCredentialsImpl(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), password, (CertificateCredentialsImpl.KeyStoreSource)new CertificateCredentialsImpl.UploadedKeyStoreSource(sb));
        try {
            if (certificateCredentialsImpl.getKeyStore().size() == 0) {
                throw new CredentialsConvertionException("certificate credential has an invalid certificate (encoded data is not a valid PKCS#12 format certificate understood by Java)");
            }
        }
        catch (KeyStoreException ex) {
            throw new CredentialsConvertionException("certificate credential has an invalid certificate (encoded data is not a valid PKCS#12 format certificate understood by Java - " + ex.getMessage() + " )");
        }
        return certificateCredentialsImpl;
    }
}

