/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.api.model.Secret;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class SecretUtils {
    private static final Logger LOG = Logger.getLogger(SecretUtils.class.getName());
    private static final String JENKINS_IO_CREDENTIALS_DESCRIPTION_ANNOTATION = "jenkins.io/credentials-description";
    private static final String JENKINS_IO_CREDENTIALS_KEYBINDING_ANNOTATION_PREFIX = "jenkins.io/credentials-keybinding-";
    static final String JENKINS_IO_CREDENTIALS_TYPE_LABEL = "jenkins.io/credentials-type";
    static final String JENKINS_IO_CREDENTIALS_SCOPE_LABEL = "jenkins.io/credentials-scope";

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static String base64DecodeToString(String s) {
        byte[] bytes = SecretUtils.base64Decode(s);
        if (bytes != null) {
            try {
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer decode = decoder.decode(ByteBuffer.wrap(bytes));
                return decode.toString();
            }
            catch (CharacterCodingException ex) {
                LOG.log(Level.WARNING, "failed to covert Secret, is this a valid UTF-8 string?  {0}", ex.getMessage());
            }
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static byte[] base64Decode(String s) {
        try {
            return Base64.getDecoder().decode(s);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.WARNING, "failed to base64decode Secret, is the format valid?  {0}", ex.getMessage());
            return null;
        }
    }

    public static CredentialsScope getCredentialScope(Secret s) throws CredentialsConvertionException {
        CredentialsScope scope = CredentialsScope.GLOBAL;
        String label = (String)s.getMetadata().getLabels().get(JENKINS_IO_CREDENTIALS_SCOPE_LABEL);
        if (label != null) {
            try {
                scope = CredentialsScope.valueOf((String)label.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException exception) {
                throw new CredentialsConvertionException("jenkins.io/credentials-scope is set to an invalid scope: " + label, exception);
            }
        }
        return scope;
    }

    public static String getCredentialId(Secret s) {
        return s.getMetadata().getName();
    }

    @CheckForNull
    public static String getCredentialDescription(Secret s) {
        Map annotations = s.getMetadata().getAnnotations();
        if (annotations != null) {
            return (String)annotations.get(JENKINS_IO_CREDENTIALS_DESCRIPTION_ANNOTATION);
        }
        return null;
    }

    public static <T> T requireNonNull(@Nullable T obj, String exceptionMessage) throws CredentialsConvertionException {
        if (obj == null) {
            throw new CredentialsConvertionException(exceptionMessage);
        }
        return obj;
    }

    public static <T> T requireNonNull(@Nullable T obj, String exceptionMessage, @Nullable String mapped) throws CredentialsConvertionException {
        if (obj == null) {
            if (mapped != null) {
                throw new CredentialsConvertionException(exceptionMessage.concat(" (mapped to " + mapped + ")"));
            }
            throw new CredentialsConvertionException(exceptionMessage);
        }
        return obj;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="the string will be the same string if not mapped")
    public static String getNonNullSecretData(Secret s, String key, String exceptionMessage) throws CredentialsConvertionException {
        String mappedKey = SecretUtils.getKeyName(s, key);
        Map data = SecretUtils.requireNonNull(s.getData(), exceptionMessage, mappedKey == key ? null : mappedKey);
        return SecretUtils.requireNonNull((String)data.get(mappedKey), exceptionMessage, mappedKey);
    }

    public static Optional<String> getOptionalSecretData(Secret s, String key, String exceptionMessage) throws CredentialsConvertionException {
        String mappedKey = SecretUtils.getKeyName(s, key);
        if (s.getData().containsKey(key) || s.getData().containsKey(mappedKey)) {
            return Optional.of(SecretUtils.getNonNullSecretData(s, key, exceptionMessage));
        }
        return Optional.empty();
    }

    public static String getKeyName(Secret s, String key) {
        Map annotations = s.getMetadata().getAnnotations();
        if (annotations != null) {
            String annotationName = JENKINS_IO_CREDENTIALS_KEYBINDING_ANNOTATION_PREFIX + key;
            String customMapping = (String)annotations.get(annotationName);
            if (customMapping == null) {
                return key;
            }
            if (customMapping.isEmpty()) {
                LOG.log(Level.WARNING, "Secret {0} contains a mapping annotation {1} but has no entry - mapping will not be performed", new Object[]{s.getMetadata().getName(), annotationName});
                return key;
            }
            return customMapping;
        }
        return key;
    }
}

