/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.LabelSelectorParseException;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class LabelSelectorExpressions {
    LabelSelectorExpressions() {
    }

    static LabelSelector parse(@Nullable String selector) throws LabelSelectorParseException {
        LabelSelectorBuilder lsb = new LabelSelectorBuilder();
        if (selector != null && !selector.trim().isEmpty()) {
            Matcher matcher = Pattern.compile("[^,]+?\\([^()]+\\)|[^,]+").matcher(selector);
            block4: while (matcher.find()) {
                String expression = matcher.group();
                expression = expression.replaceFirst("!=|=", " $0 ");
                Object[] tokens = expression.trim().split("\\s+", 3);
                switch (tokens.length) {
                    case 1: {
                        if (tokens[0].startsWith("!")) {
                            ((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)lsb.addNewMatchExpression().withKey(tokens[0].substring(1))).withOperator("DoesNotExist")).endMatchExpression();
                            continue block4;
                        }
                        ((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)lsb.addNewMatchExpression().withKey(tokens[0])).withOperator("Exists")).endMatchExpression();
                        continue block4;
                    }
                    case 3: {
                        String operator = tokens[1];
                        if ("=".equals(operator)) {
                            lsb.addToMatchLabels(tokens[0], tokens[2]);
                            continue block4;
                        }
                        if ("!=".equals(operator)) {
                            ((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)lsb.addNewMatchExpression().withKey(tokens[0])).withOperator("NotIn")).withValues(new String[]{tokens[2]})).endMatchExpression();
                            continue block4;
                        }
                        if ("notin".equalsIgnoreCase(operator)) {
                            ((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)lsb.addNewMatchExpression().withKey((String)tokens[0])).withOperator("NotIn")).withValues(LabelSelectorExpressions.values((String)tokens[2]))).endMatchExpression();
                            continue block4;
                        }
                        if ("in".equalsIgnoreCase(operator)) {
                            ((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)((LabelSelectorFluent.MatchExpressionsNested)lsb.addNewMatchExpression().withKey((String)tokens[0])).withOperator("In")).withValues(LabelSelectorExpressions.values((String)tokens[2]))).endMatchExpression();
                            continue block4;
                        }
                        throw new LabelSelectorParseException("Unrecognized selector operator '" + operator + "' in expression '" + expression + "'. Expected one of: =, !=, in, notin");
                    }
                }
                throw new LabelSelectorParseException("Invalid selector expression '" + expression + "'. Expected 1 or 3 tokens, got " + tokens.length + ": " + Arrays.toString(tokens));
            }
        }
        return lsb.build();
    }

    private static String[] values(String list) {
        return list.replaceAll("\\(|\\)", "").trim().split("\\s*,\\s*");
    }
}

