/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.KubernetesCredentialProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.export.ExportedBean;

public class KubernetesCredentialsStore
extends CredentialsStore {
    private final KubernetesCredentialProvider provider;
    private final KubernetesCredentialsStoreAction action = new KubernetesCredentialsStoreAction(this);

    public KubernetesCredentialsStore(KubernetesCredentialProvider provider) {
        super(KubernetesCredentialProvider.class);
        this.provider = provider;
    }

    @NonNull
    public ModelObject getContext() {
        return Jenkins.getInstance();
    }

    public boolean hasPermission(@NonNull Authentication authentication, @NonNull Permission permission) {
        return CredentialsProvider.VIEW.equals((Object)permission) && Jenkins.getInstance().getACL().hasPermission(authentication, permission);
    }

    @NonNull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        if (Domain.global().equals((Object)domain) && Jenkins.getInstance().hasPermission(CredentialsProvider.VIEW)) {
            return this.provider.getCredentials(Credentials.class, (ItemGroup)Jenkins.getInstance(), ACL.SYSTEM);
        }
        return Collections.emptyList();
    }

    public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static class KubernetesCredentialsStoreAction
    extends CredentialsStoreAction {
        private final KubernetesCredentialsStore store;

        private KubernetesCredentialsStoreAction(KubernetesCredentialsStore store) {
            this.store = store;
            this.addIcons();
        }

        private void addIcons() {
            IconSet.icons.addIcon(new Icon("icon-credentials-kubernetes-store icon-sm", "kubernetes-credentials-provider/images/16x16/kubernetes-store.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-credentials-kubernetes-store icon-md", "kubernetes-credentials-provider/images/24x24/kubernetes-store.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-credentials-kubernetes-store icon-lg", "kubernetes-credentials-provider/images/32x32/kubernetes-store.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-credentials-kubernetes-store icon-xlg", "kubernetes-credentials-provider/images/48x48/kubernetes-store.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }

        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getIconFileName() {
            return this.isVisible() ? "/plugin/kubernetes-credentials-provider/images/32x32/kubernetes-store.png" : null;
        }

        public String getIconClassName() {
            return this.isVisible() ? "icon-credentials-kubernetes-store" : null;
        }

        public String getDisplayName() {
            return "Kubernetes";
        }
    }
}

