/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.KubernetesCredentialsStore;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.LabelSelectorExpressions;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.LabelSelectorParseException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.TermMilestone;
import hudson.init.Terminator;
import hudson.model.AdministrativeMonitor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.AdministrativeError;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class KubernetesCredentialProvider
extends CredentialsProvider
implements Watcher<Secret> {
    private static final Logger LOG = Logger.getLogger(KubernetesCredentialProvider.class.getName());
    private ConcurrentHashMap<String, IdCredentials> credentials = new ConcurrentHashMap();
    @CheckForNull
    private KubernetesClient client;
    @CheckForNull
    private Watch watch;
    private boolean reconnectClientOnException = Boolean.parseBoolean(System.getProperty(KubernetesCredentialProvider.class.getName() + ".reconnectClientOnException", "true"));
    private int reconnectClientDelayMins = Integer.getInteger(KubernetesCredentialProvider.class.getName() + ".reconnectClientDelayMins", 5);
    private KubernetesCredentialsStore store = new KubernetesCredentialsStore(this);
    static final String LABEL_SELECTOR = KubernetesCredentialProvider.class.getName() + ".labelSelector";

    KubernetesClient getKubernetesClient() {
        if (this.client == null) {
            ConfigBuilder cb = new ConfigBuilder();
            Config config = cb.build();
            try (WithContextClassLoader ignored = new WithContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());){
                this.client = new DefaultKubernetesClient(config);
            }
        }
        return this.client;
    }

    @Initializer(after=InitMilestone.PLUGINS_PREPARED, fatal=false)
    @Restricted(value={NoExternalUse.class})
    public void startWatchingForSecrets() {
        String initAdminMonitorId = ((Object)((Object)this)).getClass().getName() + ".initialize";
        String labelSelectorAdminMonitorId = ((Object)((Object)this)).getClass().getName() + ".labelSelector";
        String labelSelector = System.getProperty(LABEL_SELECTOR);
        try {
            KubernetesClient _client = this.getKubernetesClient();
            LOG.log(Level.FINER, "Using namespace: {0}", String.valueOf(_client.getNamespace()));
            LabelSelector selector = LabelSelectorExpressions.parse(labelSelector);
            LOG.log(Level.INFO, "retrieving secrets with selector: {0}, {1}", new String[]{"jenkins.io/credentials-type", Objects.toString(selector)});
            LOG.log(Level.FINER, "retrieving secrets");
            SecretList list = (SecretList)((FilterWatchListDeletable)((FilterWatchListDeletable)_client.secrets().withLabelSelector(selector)).withLabel("jenkins.io/credentials-type")).list();
            ConcurrentHashMap<String, IdCredentials> _credentials = new ConcurrentHashMap<String, IdCredentials>();
            List secretList = list.getItems();
            for (Secret s : secretList) {
                LOG.log(Level.FINE, "Secret Added - {0}", SecretUtils.getCredentialId(s));
                this.addSecret(s, _credentials);
            }
            this.credentials = _credentials;
            LOG.log(Level.FINER, "registering watch");
            try {
                this.watch = ((FilterWatchListDeletable)((FilterWatchListDeletable)_client.secrets().withLabelSelector(selector)).withLabel("jenkins.io/credentials-type")).watch(list.getMetadata().getResourceVersion(), (Object)this);
            }
            catch (NoSuchMethodError e) {
                Object o = ((FilterWatchListDeletable)_client.secrets().withLabelSelector(selector)).withLabel("jenkins.io/credentials-type");
                try {
                    Method watchMethod = o.getClass().getMethod("watch", String.class, Watcher.class);
                    this.watch = (Watch)watchMethod.invoke(o, new Object[]{list.getMetadata().getResourceVersion(), this});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    RuntimeException runtimeException = new RuntimeException(ex);
                    runtimeException.addSuppressed(e);
                    throw runtimeException;
                }
            }
            LOG.log(Level.FINER, "registered watch, retrieving secrets");
            this.clearAdminMonitors(initAdminMonitorId, labelSelectorAdminMonitorId);
        }
        catch (KubernetesClientException kex) {
            LOG.log(Level.SEVERE, "Failed to initialise k8s secret provider, secrets from Kubernetes will not be available", kex);
            if (this.reconnectClientOnException) {
                this.reconnectLater();
            }
            this.clearAdminMonitors(initAdminMonitorId);
            new AdministrativeError(initAdminMonitorId, "Failed to initialize Kubernetes secret provider", "Credentials from Kubernetes Secrets will not be available.", (Throwable)kex);
        }
        catch (LabelSelectorParseException lex) {
            LOG.log(Level.SEVERE, "Failed to initialise k8s secret provider, secrets from Kubernetes will not be available", lex);
            this.clearAdminMonitors(labelSelectorAdminMonitorId);
            new AdministrativeError(labelSelectorAdminMonitorId, "Failed to parse Kubernetes secret label selector", "Failed to parse Kubernetes secret <a href=\"https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors\" _target=\"blank\">label selector</a> expression \"<code>" + labelSelector + "</code>\". Secrets from Kubernetes will not be available. ", (Throwable)lex);
        }
    }

    private void reconnectLater() {
        LOG.log(Level.INFO, "Attempting to reconnect Kubernetes client in {0} mins", this.reconnectClientDelayMins);
        Timer.get().schedule((Runnable)new SafeTimerTask(){

            protected void doRun() throws Exception {
                KubernetesCredentialProvider.this.startWatchingForSecrets();
            }
        }, (long)this.reconnectClientDelayMins, TimeUnit.MINUTES);
    }

    private void clearAdminMonitors(String ... ids) {
        List<String> monitorIds = Arrays.asList(ids);
        ExtensionList all = AdministrativeMonitor.all();
        List toRemove = all.stream().filter(am -> monitorIds.contains(am.id)).collect(Collectors.toList());
        all.removeAll(toRemove);
    }

    @Terminator(after=TermMilestone.STARTED)
    @Restricted(value={NoExternalUse.class})
    public void stopWatchingForSecrets() {
        if (this.watch != null) {
            this.watch.close();
            this.watch = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public <C extends Credentials> List<C> getCredentials(Class<C> type, ItemGroup itemGroup, Authentication authentication) {
        LOG.log(Level.FINEST, "getCredentials called with type {0} and authentication {1}", new Object[]{type.getName(), authentication});
        if (ACL.SYSTEM.equals(authentication)) {
            ArrayList<Credentials> list = new ArrayList<Credentials>();
            for (IdCredentials credential : this.credentials.values()) {
                LOG.log(Level.FINEST, "getCredentials {0} is a possible candidate", credential.getId());
                if (type.isAssignableFrom(credential.getClass())) {
                    LOG.log(Level.FINEST, "getCredentials {0} matches, adding to list", credential.getId());
                    list.add((Credentials)type.cast(credential));
                    continue;
                }
                LOG.log(Level.FINEST, "getCredentials {0} does not match", credential.getId());
            }
            return list;
        }
        return this.emptyList();
    }

    @NonNull
    private final <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    private void addSecret(Secret secret) {
        this.addSecret(secret, this.credentials);
    }

    private void addSecret(Secret secret, Map<String, IdCredentials> map) {
        IdCredentials cred = this.convertSecret(secret);
        if (cred != null) {
            map.put(SecretUtils.getCredentialId(secret), cred);
        }
    }

    public void eventReceived(Watcher.Action action, Secret secret) {
        String credentialId = SecretUtils.getCredentialId(secret);
        switch (action) {
            case ADDED: {
                LOG.log(Level.FINE, "Secret Added - {0}", credentialId);
                this.addSecret(secret);
                break;
            }
            case MODIFIED: {
                LOG.log(Level.FINE, "Secret Modified - {0}", credentialId);
                this.addSecret(secret);
                break;
            }
            case DELETED: {
                LOG.log(Level.FINE, "Secret Deleted - {0}", credentialId);
                this.credentials.remove(credentialId);
                break;
            }
            case ERROR: {
                LOG.log(Level.WARNING, "Action received of type Error. {0}", secret);
                break;
            }
        }
    }

    public void onClose(WatcherException cause) {
        if (cause != null) {
            LOG.log(Level.WARNING, "Secrets watch stopped unexpectedly", (Throwable)cause);
            LOG.log(Level.INFO, "Restating secrets watcher");
            this.startWatchingForSecrets();
        } else {
            LOG.log(Level.INFO, "Secrets watcher stopped");
        }
    }

    @CheckForNull
    IdCredentials convertSecret(Secret s) {
        String type = (String)s.getMetadata().getLabels().get("jenkins.io/credentials-type");
        SecretToCredentialConverter lookup = SecretToCredentialConverter.lookup(type);
        if (lookup != null) {
            try {
                return lookup.convert(s);
            }
            catch (CredentialsConvertionException ex) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Failed to convert Secret '" + SecretUtils.getCredentialId(s) + "' of type " + type, ex);
                } else {
                    LOG.log(Level.WARNING, "Failed to convert Secret ''{0}'' of type {1} due to {2}", new Object[]{SecretUtils.getCredentialId(s), type, ex.getMessage()});
                }
                return null;
            }
        }
        LOG.log(Level.WARNING, "No SecretToCredentialConverter found to convert secrets of type {0}", type);
        return null;
    }

    public CredentialsStore getStore(ModelObject object) {
        return object == Jenkins.getInstance() ? this.store : null;
    }

    public String getIconClassName() {
        return "icon-credentials-kubernetes-store";
    }

    private static class WithContextClassLoader
    implements AutoCloseable {
        private final ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();

        public WithContextClassLoader(ClassLoader classLoader) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }

        @Override
        public void close() {
            Thread.currentThread().setContextClassLoader(this.previousClassLoader);
        }
    }
}

