/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.util.ArrayList;
import java.util.Arrays;

public class ThrowBlock
implements Block {
    private final SourceLocation loc;
    private final Block exp;
    private final boolean fillStackTrace;
    private static final long serialVersionUID = 1L;

    public ThrowBlock(Block exp) {
        this(SourceLocation.UNKNOWN, exp, false);
    }

    public ThrowBlock(SourceLocation loc, Block exp, boolean fillStackTrace) {
        this.loc = loc;
        this.exp = exp;
        this.fillStackTrace = fillStackTrace;
    }

    @Override
    public Next eval(final Env e, Continuation _) {
        return new Next(this.exp, e, new Continuation(){

            @Override
            public Next receive(Object t) {
                if (t == null) {
                    t = new NullPointerException();
                }
                if (!(t instanceof Throwable)) {
                    t = new ClassCastException(t.getClass() + " cannot be cast to Throwable");
                }
                Throwable throwable = (Throwable)Throwable.class.cast(t);
                if (ThrowBlock.this.fillStackTrace) {
                    ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
                    stack.add((ThrowBlock.this.loc != null ? ThrowBlock.this.loc : SourceLocation.UNKNOWN).toStackTrace());
                    e.buildStackTraceElements(stack, Integer.MAX_VALUE);
                    stack.add(Continuable.SEPARATOR_STACK_ELEMENT);
                    stack.addAll(Arrays.asList(throwable.getStackTrace()));
                    throwable.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
                }
                Continuation v = e.getExceptionHandler(throwable.getClass());
                return v.receive(t);
            }
        });
    }
}

