/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CallEnv
implements Env {
    private final Continuation returnAddress;
    private final Env caller;
    @Nullable
    private final SourceLocation callSiteLoc;
    private Invoker invoker;
    private static final long serialVersionUID = 1L;

    public CallEnv(Env caller, Continuation returnAddress, SourceLocation loc) {
        this.caller = caller;
        this.returnAddress = returnAddress;
        this.callSiteLoc = loc;
        Invoker invoker = this.invoker = caller == null ? Invoker.INSTANCE : caller.getInvoker();
        assert (returnAddress != null);
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public final Continuation getReturnAddress() {
        return this.returnAddress;
    }

    @Override
    public final Continuation getBreakAddress(String label) {
        throw new IllegalStateException("unexpected break statement");
    }

    @Override
    public final Continuation getContinueAddress(String label) {
        throw new IllegalStateException("unexpected continue statement");
    }

    @Override
    public final Continuation getExceptionHandler(Class<? extends Throwable> type) {
        if (this.caller == null) {
            return new Continuation(){

                public Next receive(Object o) {
                    return Next.unhandledException((Throwable)o);
                }
            };
        }
        return this.caller.getExceptionHandler(type);
    }

    @Override
    public void buildStackTraceElements(List<StackTraceElement> stack, int depth) {
        if (this.callSiteLoc != null) {
            stack.add(this.callSiteLoc.toStackTrace());
        }
        if (this.caller != null && depth > 1) {
            this.caller.buildStackTraceElements(stack, depth - 1);
        }
    }
}

