/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.green;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.green.Cond;
import com.cloudbees.groovy.cps.green.GreenThread;
import com.cloudbees.groovy.cps.green.Monitor;
import java.io.Serializable;

final class GreenThreadState
implements Serializable {
    final Next n;
    final GreenThread g;
    final Monitor monitor;
    final Cond cond;
    final Object wait;
    private static final long serialVersionUID = 1L;

    private GreenThreadState(GreenThread g, Next n, Monitor monitor, Cond cond, Object wait) {
        this.g = g;
        this.n = n;
        this.monitor = monitor;
        this.cond = cond;
        this.wait = wait;
        assert (cond == null == (wait == null));
    }

    private GreenThreadState(GreenThread g, Next n) {
        this(g, n, null, null, null);
    }

    GreenThreadState(GreenThread g, Block b) {
        this(g, new Next(b, Envs.empty(), Continuation.HALT));
    }

    GreenThreadState(GreenThread g, Outcome v) {
        this(g, new Next(null, Continuation.HALT, v));
    }

    GreenThreadState with(Next n) {
        return new GreenThreadState(this.g, n, this.monitor, this.cond, this.wait);
    }

    GreenThreadState with(Monitor monitor) {
        return new GreenThreadState(this.g, this.n, monitor, this.cond, this.wait);
    }

    GreenThreadState withCond(Cond cond, Object o) {
        return new GreenThreadState(this.g, this.n, this.monitor, cond, o);
    }

    GreenThreadState pushMonitor(Object o) {
        return this.with(new Monitor(this.monitor, o));
    }

    GreenThreadState popMonitor() {
        return this.with(this.monitor.next);
    }

    boolean isRunnable() {
        return this.cond == null;
    }

    public boolean isDead() {
        return this.n.k == Continuation.HALT && this.n.e == null;
    }

    public Outcome getResult() {
        if (this.isDead()) {
            return this.n.yield;
        }
        throw new IllegalStateException("Green thread is still running");
    }

    GreenThreadState tick(Object o) {
        return this.resumeFrom(new Outcome(o, null));
    }

    GreenThreadState resumeFrom(Outcome o) {
        return this.with(o.resumeFrom(this.n.e, this.n.k));
    }

    GreenThreadState step() {
        return this.with(this.n.step());
    }

    boolean hasMonitor(Object o) {
        if (this.wait == o && (this.cond == Cond.WAIT || this.cond == Cond.NOTIFIED)) {
            return false;
        }
        Monitor m = this.monitor;
        while (m != null) {
            if (m.o == o) {
                return true;
            }
            m = m.next;
        }
        return false;
    }
}

