/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Next;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContinuationPtr
implements Serializable {
    private transient Method m;
    private static final long serialVersionUID = 1L;

    ContinuationPtr(Class<?> type, String methodName) {
        this.resolveMethod(type, methodName);
    }

    private void resolveMethod(Class<?> type, String methodName) {
        try {
            this.m = type.getMethod(methodName, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    Continuation bind(Object target) {
        return new ContinuationImpl(target);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Class c = (Class)ois.readObject();
        String methodName = ois.readUTF();
        this.resolveMethod(c, methodName);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.m.getDeclaringClass());
        oos.writeUTF(this.m.getName());
    }

    private class ContinuationImpl
    implements Continuation {
        private final Object target;
        private static final long serialVersionUID = 1L;

        public ContinuationImpl(Object target) {
            this.target = target;
        }

        public Next receive(Object o) {
            try {
                return (Next)ContinuationPtr.this.m.invoke(this.target, o);
            }
            catch (IllegalAccessException e) {
                throw (IllegalAccessError)new IllegalAccessError().initCause(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new Error(e);
            }
        }
    }
}

