/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.diff;

import com.cloudbees.diff.Diff;
import com.cloudbees.diff.Difference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HuntDiff {
    private HuntDiff() {
    }

    public static Diff diff(List<String> lines1, List<String> lines2, boolean ignoreWhitespace) {
        int m = lines1.size();
        int n = lines2.size();
        List<String> orig1 = lines1;
        List<String> orig2 = lines2;
        if (ignoreWhitespace) {
            lines1 = HuntDiff.trimLines(lines1);
            lines2 = HuntDiff.trimLines(lines2);
        }
        Object[] l2s = new Line[n + 1];
        for (int i = 1; i <= n; ++i) {
            l2s[i] = new Line(i, lines2.get(i - 1));
        }
        Arrays.sort(l2s, 1, n + 1);
        int[] equvalenceLines = new int[n + 1];
        boolean[] equivalence = new boolean[n + 1];
        for (int i = 1; i <= n; ++i) {
            Object l = l2s[i];
            equvalenceLines[i] = ((Line)l).lineNo;
            equivalence[i] = i == n || !((Line)l).line.equals(((Line)l2s[i + 1]).line);
        }
        equvalenceLines[0] = 0;
        equivalence[0] = true;
        int[] equivalenceAssoc = new int[m + 1];
        for (int i = 1; i <= m; ++i) {
            equivalenceAssoc[i] = HuntDiff.findAssoc(lines1.get(i - 1), (Line[])l2s, equivalence);
        }
        l2s = null;
        Candidate[] K = new Candidate[Math.min(m, n) + 2];
        K[0] = new Candidate(0, 0, null);
        K[1] = new Candidate(m + 1, n + 1, null);
        int k = 0;
        for (int i = 1; i <= m; ++i) {
            if (equivalenceAssoc[i] == 0) continue;
            k = HuntDiff.merge(K, k, i, equvalenceLines, equivalence, equivalenceAssoc[i]);
        }
        int[] J = new int[m + 2];
        Candidate c = K[k];
        while (c != null) {
            J[((Candidate)c).a] = c.b;
            c = c.c;
        }
        Diff differences = HuntDiff.getDifferences(J, orig1, orig2);
        HuntDiff.cleanup(differences);
        return differences;
    }

    private static List<String> trimLines(List<String> lines) {
        ArrayList<String> r = new ArrayList<String>(lines.size());
        for (String s : lines) {
            r.add(s.trim());
        }
        return r;
    }

    private static int findAssoc(String line1, Line[] l2s, boolean[] equivalence) {
        int idx = HuntDiff.binarySearch(l2s, line1, 1, l2s.length - 1);
        if (idx < 1) {
            return 0;
        }
        int lastGoodIdx = 0;
        while (idx >= 1 && l2s[idx].line.equals(line1)) {
            if (equivalence[idx - 1]) {
                lastGoodIdx = idx;
            }
            --idx;
        }
        return lastGoodIdx;
    }

    private static int binarySearch(Line[] L, String key, int low, int high) {
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = L[mid].line;
            int comparison = midVal.compareTo(key);
            if (comparison < 0) {
                low = mid + 1;
                continue;
            }
            if (comparison > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch(Candidate[] K, int key, int low, int high) {
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = K[mid].b;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int merge(Candidate[] K, int k, int i, int[] equvalenceLines, boolean[] equivalence, int p) {
        int r = 0;
        Candidate c = K[0];
        while (true) {
            int j;
            int s;
            if ((s = HuntDiff.binarySearch(K, j = equvalenceLines[p], r, k)) >= 0) {
                s = k + 1;
            } else if ((s = -s - 2) < r || s > k) {
                s = k + 1;
            }
            if (s <= k) {
                if (K[s + 1].b > j) {
                    Candidate newc = new Candidate(i, j, K[s]);
                    K[r] = c;
                    r = s + 1;
                    c = newc;
                }
                if (s == k) {
                    K[k + 2] = K[k + 1];
                    ++k;
                    break;
                }
            }
            if (equivalence[p]) break;
            ++p;
        }
        K[r] = c;
        return k;
    }

    private static Diff getDifferences(int[] J, List<String> lines1, List<String> lines2) {
        StringBuilder addedText;
        int end2;
        Diff differences = new Diff();
        int n = lines1.size();
        int m = lines2.size();
        int start1 = 1;
        int start2 = 1;
        while (true) {
            if (start1 <= n && J[start1] == start2) {
                ++start1;
                ++start2;
                continue;
            }
            if (start1 > n) break;
            if (J[start1] < start2) {
                int end1;
                StringBuilder deletedText = new StringBuilder();
                deletedText.append(lines1.get(start1 - 1)).append('\n');
                for (end1 = start1 + 1; end1 <= n && J[end1] < start2; ++end1) {
                    String line = lines1.get(end1 - 1);
                    deletedText.append(line).append('\n');
                }
                differences.add(new Difference(0, start1, end1 - 1, start2 - 1, 0, deletedText.toString(), null));
                start1 = end1;
            } else {
                end2 = J[start1];
                addedText = new StringBuilder();
                for (int i = start2; i < end2; ++i) {
                    String line = lines2.get(i - 1);
                    addedText.append(line).append('\n');
                }
                differences.add(new Difference(1, start1 - 1, 0, start2, end2 - 1, null, addedText.toString()));
                start2 = end2;
            }
            if (start1 > n) break;
        }
        if (start2 <= m) {
            addedText = new StringBuilder();
            addedText.append(lines2.get(start2 - 1)).append('\n');
            for (end2 = start2 + 1; end2 <= m; ++end2) {
                String line = lines2.get(end2 - 1);
                addedText.append(line).append('\n');
            }
            differences.add(new Difference(1, n, 0, start2, m, null, addedText.toString()));
        }
        return differences;
    }

    private static void cleanup(List<Difference> diffs) {
        Difference last = null;
        for (int i = 0; i < diffs.size(); ++i) {
            Difference diff = diffs.get(i);
            if (last != null && (diff.getType() == 1 && last.getType() == 0 || diff.getType() == 0 && last.getType() == 1)) {
                Difference del;
                Difference add;
                if (1 == diff.getType()) {
                    add = diff;
                    del = last;
                } else {
                    add = last;
                    del = diff;
                }
                int d1f1l1 = add.getFirstStart() - (del.getFirstEnd() - del.getFirstStart());
                int d2f1l1 = del.getFirstStart();
                if (d1f1l1 == d2f1l1) {
                    Difference newDiff = new Difference(2, d1f1l1, del.getFirstEnd(), add.getSecondStart(), add.getSecondEnd(), del.getFirstText(), add.getSecondText());
                    diffs.set(i - 1, newDiff);
                    diffs.remove(i);
                    --i;
                    diff = newDiff;
                }
            }
            last = diff;
        }
    }

    private static class Candidate {
        private int a;
        private int b;
        private Candidate c;

        public Candidate(int a, int b, Candidate c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Line
    implements Comparable<Line> {
        public int lineNo;
        public String line;
        public int hash;

        public Line(int lineNo, String line) {
            this.lineNo = lineNo;
            this.line = line;
            this.hash = line.hashCode();
        }

        @Override
        public int compareTo(Line that) {
            return this.line.compareTo(that.line);
        }
    }
}

