/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.diff;

import com.cloudbees.diff.Difference;
import com.cloudbees.diff.HuntDiff;
import com.cloudbees.diff.Patch;
import com.cloudbees.diff.TextDiffInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff
extends ArrayList<Difference>
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Diff diff(File f1, File f2, boolean ignoreWhitespace) throws IOException {
        FileReader r1 = new FileReader(f1);
        try {
            Diff diff;
            FileReader r2 = new FileReader(f2);
            try {
                diff = Diff.diff(r1, r2, ignoreWhitespace);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Reader)r2);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)r2);
            return diff;
        }
        finally {
            IOUtils.closeQuietly((Reader)r1);
        }
    }

    public static Diff diff(Reader r1, Reader r2, boolean ignoreWhitespace) throws IOException {
        return Diff.diff(Diff.getLines(r1), Diff.getLines(r2), ignoreWhitespace);
    }

    private static List<String> getLines(Reader r) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static Diff diff(List<String> lines1, List<String> lines2, boolean ignoreWhitespace) {
        return HuntDiff.diff(lines1, lines2, ignoreWhitespace);
    }

    public String toUnifiedDiff(String name1, String name2, Reader r1, Reader r2, int numContextLines) throws IOException {
        return new TextDiffInfo(name1, name2, r1, r2, this).toUnifiedDiffText(numContextLines);
    }

    public Reader apply(Reader source) {
        return new Patch(this, source);
    }
}

