/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public final class ValueConverters {
    private final Map<Class<?>, Map<Class<?>, Function<Object, Object>>> classConverters;
    private final ImmutableMap<Class<?>, Function<Object, Object>> numberConverters;

    public ValueConverters() {
        ImmutableMap.Builder numberConvertersBuilder = ImmutableMap.builder();
        numberConvertersBuilder.put(String.class, this::convertNumberToString);
        numberConvertersBuilder.put(Boolean.class, this::convertNumberToBoolean);
        numberConvertersBuilder.put(Byte.TYPE, this::convertNumberToByte);
        numberConvertersBuilder.put(Short.TYPE, this::convertNumberToShort);
        numberConvertersBuilder.put(Integer.TYPE, this::convertNumberToInt);
        numberConvertersBuilder.put(Long.TYPE, this::convertNumberToLong);
        numberConvertersBuilder.put(Float.TYPE, this::convertNumberToFloat);
        numberConvertersBuilder.put(Double.TYPE, this::convertNumberToDouble);
        numberConvertersBuilder.put(Byte.class, this::convertNumberToByte);
        numberConvertersBuilder.put(Short.class, this::convertNumberToShort);
        numberConvertersBuilder.put(Integer.class, this::convertNumberToInt);
        numberConvertersBuilder.put(Long.class, this::convertNumberToLong);
        numberConvertersBuilder.put(Float.class, this::convertNumberToFloat);
        numberConvertersBuilder.put(Double.class, this::convertNumberToDouble);
        numberConvertersBuilder.put(BigInteger.class, this::convertNumberToBigInteger);
        numberConvertersBuilder.put(BigDecimal.class, this::convertNumberToBigDecimal);
        this.numberConverters = numberConvertersBuilder.build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put(Byte.TYPE, this.numberConverters);
        mapBuilder.put(Short.TYPE, this.numberConverters);
        mapBuilder.put(Integer.TYPE, this.numberConverters);
        mapBuilder.put(Long.TYPE, this.numberConverters);
        mapBuilder.put(Float.TYPE, this.numberConverters);
        mapBuilder.put(Double.TYPE, this.numberConverters);
        mapBuilder.put(Byte.class, this.numberConverters);
        mapBuilder.put(Short.class, this.numberConverters);
        mapBuilder.put(Integer.class, this.numberConverters);
        mapBuilder.put(Long.class, this.numberConverters);
        mapBuilder.put(Float.class, this.numberConverters);
        mapBuilder.put(Double.class, this.numberConverters);
        mapBuilder.put(BigInteger.class, this.numberConverters);
        mapBuilder.put(BigDecimal.class, this.numberConverters);
        ImmutableMap.Builder booleanMapBuilder = ImmutableMap.builder();
        booleanMapBuilder.put(Byte.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Short.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Integer.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Long.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Float.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Double.TYPE, this::convertBooleanToNumber);
        booleanMapBuilder.put(Byte.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(Short.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(Integer.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(Long.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(Float.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(Double.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(BigInteger.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(BigDecimal.class, this::convertBooleanToNumber);
        booleanMapBuilder.put(String.class, this::convertBooleanToString);
        booleanMapBuilder.put(Boolean.class, this::convertBooleanToBoolean);
        booleanMapBuilder.put(Boolean.TYPE, this::convertBooleanToBoolean);
        mapBuilder.put(Boolean.class, (Object)booleanMapBuilder.build());
        mapBuilder.put(Boolean.TYPE, (Object)booleanMapBuilder.build());
        ImmutableMap.Builder stringMapBuilder = ImmutableMap.builder();
        stringMapBuilder.put(Byte.TYPE, this::convertStringToByte);
        stringMapBuilder.put(Short.TYPE, this::convertStringToShort);
        stringMapBuilder.put(Integer.TYPE, this::convertStringToInt);
        stringMapBuilder.put(Long.TYPE, this::convertStringToLong);
        stringMapBuilder.put(Float.TYPE, this::convertStringToFloat);
        stringMapBuilder.put(Double.TYPE, this::convertStringToDouble);
        stringMapBuilder.put(Byte.class, this::convertStringToByte);
        stringMapBuilder.put(Short.class, this::convertStringToShort);
        stringMapBuilder.put(Integer.class, this::convertStringToInt);
        stringMapBuilder.put(Long.class, this::convertStringToLong);
        stringMapBuilder.put(Float.class, this::convertStringToFloat);
        stringMapBuilder.put(Double.class, this::convertStringToDouble);
        stringMapBuilder.put(Boolean.class, this::convertStringToBoolean);
        stringMapBuilder.put(String.class, this::convertStringToString);
        stringMapBuilder.put(byte[].class, this::convertStringToBytes);
        stringMapBuilder.put(URL.class, this::convertStringToURL);
        mapBuilder.put(String.class, (Object)stringMapBuilder.build());
        mapBuilder.put(Date.class, (Object)ImmutableMap.of(Date.class, this::convertSqlDateToSqlDate, String.class, this::convertDateToString));
        mapBuilder.put(Time.class, (Object)ImmutableMap.of(Time.class, this::convertSqlTimeToSqlTime, String.class, this::convertTimeToString));
        mapBuilder.put(Timestamp.class, (Object)ImmutableMap.of(Timestamp.class, this::convertSqlTimestampToSqlTimestamp, String.class, this::convertTimestampToString));
        this.classConverters = mapBuilder.build();
    }

    public Boolean convertBooleanToBoolean(Object value) {
        return (Boolean)value;
    }

    public Number convertBooleanToNumber(Object value) {
        return (Boolean)value != false ? 1L : 0L;
    }

    public String convertBooleanToString(Object value) {
        return String.valueOf(value);
    }

    public String convertStringToString(Object value) {
        return (String)value;
    }

    public byte[] convertStringToBytes(Object value) {
        return ((String)value).getBytes();
    }

    public boolean convertStringToBoolean(Object value) {
        return Boolean.parseBoolean((String)value);
    }

    public byte convertStringToByte(Object value) {
        return Byte.parseByte((String)value);
    }

    public short convertStringToShort(Object value) {
        return Short.parseShort((String)value);
    }

    public int convertStringToInt(Object value) {
        return Integer.parseInt((String)value);
    }

    public long convertStringToLong(Object value) {
        return Long.parseLong((String)value);
    }

    public float convertStringToFloat(Object value) {
        return Float.parseFloat((String)value);
    }

    public double convertStringToDouble(Object value) {
        return Double.parseDouble((String)value);
    }

    public URL convertStringToURL(Object value) {
        try {
            return new URL((String)value);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String convertNumberToString(Object value) {
        return String.valueOf(value);
    }

    public boolean convertNumberToBoolean(Object value) {
        return ((Number)value).floatValue() != 0.0f;
    }

    public byte convertNumberToByte(Object value) {
        return ((Number)value).byteValue();
    }

    public short convertNumberToShort(Object value) {
        return ((Number)value).shortValue();
    }

    public int convertNumberToInt(Object value) {
        return ((Number)value).intValue();
    }

    public long convertNumberToLong(Object value) {
        return ((Number)value).longValue();
    }

    public float convertNumberToFloat(Object value) {
        return ((Number)value).floatValue();
    }

    public double convertNumberToDouble(Object value) {
        return ((Number)value).doubleValue();
    }

    public BigInteger convertNumberToBigInteger(Object value) {
        return BigInteger.valueOf(((Number)value).longValue());
    }

    public BigDecimal convertNumberToBigDecimal(Object value) {
        return BigDecimal.valueOf(((Number)value).doubleValue());
    }

    public Date convertSqlDateToSqlDate(Object value) {
        return (Date)value;
    }

    public Time convertSqlTimeToSqlTime(Object value) {
        return (Time)value;
    }

    public Timestamp convertSqlTimestampToSqlTimestamp(Object value) {
        return (Timestamp)value;
    }

    public String convertDateToString(Object value) {
        return value.toString();
    }

    public String convertTimeToString(Object value) {
        return value.toString();
    }

    public String convertTimestampToString(Object value) {
        return value.toString();
    }

    public Map<Class<?>, Function<Object, Object>> getConvertersForType(Class<?> type) {
        return this.classConverters.getOrDefault(type, Collections.emptyMap());
    }
}

