/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.ClickHouseException;
import com.clickhouse.client.api.DataTypeUtils;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.internal.BaseCollectionConverter;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class DataTypeConverter {
    private static final char QUOTE = '\'';
    private static final String NULL = "NULL";
    public static final DataTypeConverter INSTANCE = new DataTypeConverter();
    private final ListAsStringWriter listAsStringWriter = new ListAsStringWriter();
    private final ArrayAsStringWriter arrayAsStringWriter = new ArrayAsStringWriter();
    public static ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    public static final ZonedDateTime EPOCH_START_OF_THE_DAY = ZonedDateTime.ofInstant(Instant.EPOCH, UTC_ZONE_ID);
    public static final LocalDate EPOCH_DATE = LocalDate.of(1970, 1, 1);

    public String convertToString(Object value, ClickHouseColumn column) {
        if (value == null) {
            return null;
        }
        switch (column.getDataType()) {
            case String: {
                return this.stringToString(value, column);
            }
            case Date: 
            case Date32: {
                return this.dateToString(value, column);
            }
            case Time: 
            case Time64: {
                return this.timeToString(value, column);
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                return this.dateTimeToString(value, column);
            }
            case Enum8: 
            case Enum16: 
            case Enum: {
                return this.enumToString(value, column);
            }
            case IPv4: 
            case IPv6: {
                return this.ipvToString(value, column);
            }
            case Array: {
                return this.arrayToString(value, column);
            }
            case Variant: 
            case Dynamic: {
                return this.variantOrDynamicToString(value, column);
            }
        }
        return value.toString();
    }

    public String stringToString(Object bytesOrString, ClickHouseColumn column) {
        StringBuilder sb = new StringBuilder();
        if (column.isArray()) {
            sb.append('\'');
        }
        if (bytesOrString instanceof CharSequence) {
            sb.append((CharSequence)bytesOrString);
        } else if (bytesOrString instanceof byte[]) {
            sb.append(new String((byte[])bytesOrString));
        } else {
            sb.append(bytesOrString);
        }
        if (column.isArray()) {
            sb.append('\'');
        }
        return sb.toString();
    }

    public String dateToString(Object value, ClickHouseColumn column) {
        DateTimeFormatter formatter = DataTypeUtils.DATE_FORMATTER;
        if (value instanceof ZonedDateTime || value instanceof LocalDateTime) {
            TemporalAccessor dateTime = (TemporalAccessor)value;
            return formatter.format(dateTime);
        }
        if (value instanceof LocalDate) {
            return formatter.format((LocalDate)value);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), UTC_ZONE_ID));
        }
        if (value instanceof Time) {
            return formatter.format(EPOCH_START_OF_THE_DAY);
        }
        if (value instanceof java.util.Date) {
            return formatter.format(((java.util.Date)value).toInstant().atZone(UTC_ZONE_ID));
        }
        return value.toString();
    }

    public String timeToString(Object value, ClickHouseColumn column) {
        DateTimeFormatter formatter;
        switch (column.getDataType()) {
            case Time64: {
                formatter = DataTypeUtils.TIME_WITH_NANOS_FORMATTER;
                break;
            }
            default: {
                formatter = DataTypeUtils.TIME_FORMATTER;
            }
        }
        if (value instanceof ZonedDateTime || value instanceof LocalDateTime) {
            TemporalAccessor dateTime = (TemporalAccessor)value;
            return formatter.format(dateTime);
        }
        if (value instanceof LocalTime) {
            return formatter.format((LocalTime)value);
        }
        if (value instanceof Date) {
            return formatter.format(EPOCH_START_OF_THE_DAY);
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            LocalTime lt = time.toLocalTime();
            return formatter.format(lt);
        }
        if (value instanceof java.util.Date) {
            return formatter.format(((java.util.Date)value).toInstant().atZone(UTC_ZONE_ID));
        }
        return value.toString();
    }

    public String dateTimeToString(Object value, ClickHouseColumn column) {
        DateTimeFormatter formatter;
        switch (column.getDataType()) {
            case DateTime64: {
                formatter = DataTypeUtils.DATETIME_WITH_NANOS_FORMATTER;
                break;
            }
            default: {
                formatter = DataTypeUtils.DATETIME_FORMATTER;
            }
        }
        if (value instanceof ZonedDateTime || value instanceof LocalDateTime) {
            TemporalAccessor dateTime = (TemporalAccessor)value;
            return formatter.format(dateTime);
        }
        if (value instanceof LocalDate) {
            return formatter.format(((LocalDate)value).atStartOfDay());
        }
        if (value instanceof LocalTime) {
            return formatter.format(((LocalTime)value).atDate(LocalDate.now()));
        }
        if (value instanceof Date) {
            return formatter.format(EPOCH_START_OF_THE_DAY);
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            LocalTime lt = time.toLocalTime();
            return formatter.format(lt.atDate(EPOCH_DATE));
        }
        if (value instanceof java.util.Date) {
            return formatter.format(((java.util.Date)value).toInstant().atZone(UTC_ZONE_ID));
        }
        return value.toString();
    }

    public String enumToString(Object value, ClickHouseColumn column) {
        if (value instanceof BinaryStreamReader.EnumValue) {
            return ((BinaryStreamReader.EnumValue)value).name;
        }
        if (value instanceof Number) {
            int num = ((Number)value).intValue();
            switch (column.getDataType()) {
                case Enum8: 
                case Enum16: 
                case Enum: {
                    return column.getEnumConstants().name(num);
                }
            }
        }
        return value.toString();
    }

    public String ipvToString(Object value, ClickHouseColumn column) {
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    public String arrayToString(Object value, ClickHouseColumn column) {
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return this.listAsStringWriter.convertAndReset(((BinaryStreamReader.ArrayValue)value).asList(), new StringBuilder(), column);
        }
        if (value.getClass().isArray()) {
            return this.arrayAsStringWriter.convertAndReset(value, new StringBuilder(), column);
        }
        if (value instanceof List) {
            return this.listAsStringWriter.convertAndReset((List)value, new StringBuilder(), column);
        }
        return value.toString();
    }

    public String arrayToString(Object value, String columnDef) {
        ClickHouseColumn column = ClickHouseColumn.of((String)"v", (String)columnDef);
        return this.arrayToString(value, column);
    }

    public String variantOrDynamicToString(Object value, ClickHouseColumn column) {
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return this.arrayToString(value, column);
        }
        return value.toString();
    }

    private static void appendEnquotedArrayElement(String value, ClickHouseColumn elementColumn, Appendable appendable) {
        try {
            if (elementColumn != null && elementColumn.getDataType() == ClickHouseDataType.String) {
                appendable.append('\'').append(value).append('\'');
            } else {
                appendable.append(value);
            }
        }
        catch (IOException e) {
            throw new ClickHouseException(e.getMessage(), e);
        }
    }

    private final class ListAsStringWriter
    extends BaseCollectionConverter.BaseListWriter {
        private ClickHouseColumn column;

        private ListAsStringWriter() {
        }

        public void setColumn(ClickHouseColumn column) {
            this.column = column;
        }

        @Override
        protected void onItem(Object item, BaseCollectionConverter.ListConversionState<List<?>> state) {
            if (item == null) {
                this.append(DataTypeConverter.NULL);
                return;
            }
            ClickHouseColumn elementColumn = this.column.getArrayBaseColumn() == null ? this.column : this.column.getArrayBaseColumn();
            String str = DataTypeConverter.this.convertToString(item, elementColumn);
            DataTypeConverter.appendEnquotedArrayElement(str, elementColumn, this.appendable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String convertAndReset(List<?> list, Appendable acc, ClickHouseColumn column) {
            try {
                this.setColumn(column);
                String string = super.convert(list, acc);
                return string;
            }
            finally {
                this.column = null;
                this.setAccumulator(null);
            }
        }
    }

    private final class ArrayAsStringWriter
    extends BaseCollectionConverter.BaseArrayWriter {
        private ClickHouseColumn column;

        ArrayAsStringWriter() {
        }

        public void setColumn(ClickHouseColumn column) {
            this.column = column;
        }

        @Override
        protected void onItem(Object item, BaseCollectionConverter.ListConversionState<Object> state) {
            if (item == null) {
                this.append(DataTypeConverter.NULL);
                return;
            }
            ClickHouseColumn elementColumn = this.column.getArrayBaseColumn() == null ? this.column : this.column.getArrayBaseColumn();
            String str = DataTypeConverter.this.convertToString(item, elementColumn);
            DataTypeConverter.appendEnquotedArrayElement(str, elementColumn, this.appendable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String convertAndReset(Object list, Appendable acc, ClickHouseColumn column) {
            try {
                this.setColumn(column);
                String string = super.convert(list, acc);
                return string;
            }
            finally {
                this.column = null;
                this.setAccumulator(null);
            }
        }
    }
}

