/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseFormat;
import java.io.InputStream;
import java.util.TimeZone;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;

public class QueryResponse
implements AutoCloseable {
    private final ClickHouseFormat format;
    private QuerySettings settings;
    private OperationMetrics operationMetrics;
    private ClassicHttpResponse httpResponse;

    public QueryResponse(ClassicHttpResponse response, ClickHouseFormat format, QuerySettings settings, OperationMetrics operationMetrics) {
        this.httpResponse = response;
        this.format = format;
        this.operationMetrics = operationMetrics;
        this.settings = settings;
        Header tzHeader = response.getFirstHeader("X-ClickHouse-Timezone");
        if (tzHeader != null) {
            try {
                this.settings.setOption(ClientConfigProperties.SERVER_TIMEZONE.getKey(), TimeZone.getTimeZone(tzHeader.getValue()));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse server timezone", e);
            }
        }
    }

    public InputStream getInputStream() {
        try {
            return this.httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new ClientException("Failed to construct input stream", e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.httpResponse != null) {
            try {
                this.httpResponse.close();
            }
            catch (Exception e) {
                throw new ClientException("Failed to close response", e);
            }
        }
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public OperationMetrics getMetrics() {
        return this.operationMetrics;
    }

    public long getReadRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_READ).getLong();
    }

    public long getReadBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_READ).getLong();
    }

    public long getWrittenRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_WRITTEN).getLong();
    }

    public long getWrittenBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_WRITTEN).getLong();
    }

    public long getServerTime() {
        return this.operationMetrics.getMetric(ServerMetrics.ELAPSED_TIME).getLong();
    }

    public long getResultRows() {
        return this.operationMetrics.getMetric(ServerMetrics.RESULT_ROWS).getLong();
    }

    public String getQueryId() {
        return this.operationMetrics.getQueryId();
    }

    public TimeZone getTimeZone() {
        return this.settings.getOption(ClientConfigProperties.SERVER_TIMEZONE.getKey()) == null ? null : (TimeZone)this.settings.getOption(ClientConfigProperties.SERVER_TIMEZONE.getKey());
    }

    public QuerySettings getSettings() {
        return this.settings;
    }
}

