/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NativeFormatReader
extends AbstractBinaryFormatReader {
    private Block currentBlock;
    private int blockRowIndex;

    public NativeFormatReader(InputStream inputStream, QuerySettings settings, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator) {
        super(inputStream, settings, null, byteBufferAllocator);
        this.readNextRecord();
    }

    @Override
    public boolean readRecord(Map<String, Object> record) throws IOException {
        if (!(this.currentBlock != null && this.blockRowIndex < this.currentBlock.getnRows() || this.readBlock())) {
            return false;
        }
        this.currentBlock.fillRecord(this.blockRowIndex, record);
        ++this.blockRowIndex;
        return true;
    }

    private boolean readBlock() throws IOException {
        int nColumns;
        try {
            nColumns = BinaryStreamReader.readVarInt(this.input);
        }
        catch (EOFException e) {
            this.endReached();
            return false;
        }
        int nRows = BinaryStreamReader.readVarInt(this.input);
        ArrayList<String> names = new ArrayList<String>(nColumns);
        ArrayList<String> types = new ArrayList<String>(nColumns);
        this.currentBlock = new Block(names, types, nRows);
        for (int i = 0; i < nColumns; ++i) {
            ClickHouseColumn column = ClickHouseColumn.of((String)BinaryStreamReader.readString(this.input), (String)BinaryStreamReader.readString(this.input));
            names.add(column.getColumnName());
            types.add(column.getDataType().name());
            ArrayList<Object> values = new ArrayList<Object>(nRows);
            for (int j = 0; j < nRows; ++j) {
                Object value = this.binaryStreamReader.readValue(column);
                values.add(value);
            }
            this.currentBlock.add(values);
        }
        this.blockRowIndex = 0;
        return true;
    }

    @Override
    public <T> T readValue(int colIndex) {
        return (T)this.currentRecord.get(this.getSchema().indexToName(colIndex));
    }

    @Override
    public <T> T readValue(String colName) {
        return (T)this.currentRecord.get(colName);
    }

    private static class Block {
        final List<String> names;
        final List<String> types;
        final List<List<Object>> values = new ArrayList<List<Object>>();
        final int nRows;

        Block(List<String> names, List<String> types, int nRows) {
            this.names = names;
            this.types = types;
            this.nRows = nRows;
        }

        public void add(List<Object> values) {
            this.values.add(values);
        }

        public int getnRows() {
            return this.nRows;
        }

        private void fillRecord(int index, Map<String, Object> record) {
            int colIndex = 0;
            for (String name : this.names) {
                record.put(name, this.values.get(colIndex).get(index));
                ++colIndex;
            }
        }
    }
}

