/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import java.util.concurrent.TimeUnit;

public class QueryResponse
implements AutoCloseable {
    private final ClickHouseResponse clickHouseResponse;
    private final ClickHouseFormat format;
    private long completeTimeout = TimeUnit.MINUTES.toMillis(1L);
    private ClickHouseClient client;
    private QuerySettings settings;
    private OperationMetrics operationMetrics;
    private volatile boolean completed = false;

    public QueryResponse(ClickHouseClient client, ClickHouseResponse clickHouseResponse, QuerySettings settings, ClickHouseFormat format, ClientStatisticsHolder clientStatisticsHolder) {
        this.client = client;
        this.clickHouseResponse = clickHouseResponse;
        this.format = format;
        this.settings = settings;
        this.operationMetrics = new OperationMetrics(clientStatisticsHolder);
        this.operationMetrics.operationComplete(clickHouseResponse.getSummary());
    }

    public ClickHouseInputStream getInputStream() {
        try {
            return this.clickHouseResponse.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.clickHouseResponse.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed to close response", e);
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed to close client", e);
        }
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public OperationMetrics getMetrics() {
        return this.operationMetrics;
    }

    public long getReadRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_READ).getLong();
    }

    public long getReadBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_READ).getLong();
    }

    public long getWrittenRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_WRITTEN).getLong();
    }

    public long getWrittenBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_WRITTEN).getLong();
    }

    public long getServerTime() {
        return this.operationMetrics.getMetric(ServerMetrics.ELAPSED_TIME).getLong();
    }

    public long getResultRows() {
        return this.operationMetrics.getMetric(ServerMetrics.RESULT_ROWS).getLong();
    }

    public String getQueryId() {
        return this.operationMetrics.getQueryId();
    }
}

