/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.command.CommandResponse;
import com.clickhouse.client.api.command.CommandSettings;
import com.clickhouse.client.api.data_formats.RowBinaryWithNamesAndTypesFormatReader;
import com.clickhouse.client.api.data_formats.internal.MapBackedRecord;
import com.clickhouse.client.api.enums.Protocol;
import com.clickhouse.client.api.enums.ProxyType;
import com.clickhouse.client.api.insert.DataSerializationException;
import com.clickhouse.client.api.insert.InsertResponse;
import com.clickhouse.client.api.insert.InsertSettings;
import com.clickhouse.client.api.insert.POJOSerializer;
import com.clickhouse.client.api.insert.SerializerNotFoundException;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.ClientV1AdaptorHelper;
import com.clickhouse.client.api.internal.SerializerUtils;
import com.clickhouse.client.api.internal.SettingsConverter;
import com.clickhouse.client.api.internal.TableSchemaParser;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.metrics.ClientMetrics;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.api.query.Records;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final String DEFAULT_DB_NAME = "default";
    private Set<String> endpoints;
    private Map<String, String> configuration;
    private List<ClickHouseNode> serverNodes = new ArrayList<ClickHouseNode>();
    private Map<Class<?>, List<POJOSerializer>> serializers;
    private Map<Class<?>, Map<String, Method>> getterMethods;
    private Map<Class<?>, Boolean> hasDefaults;
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private ExecutorService queryExecutor;
    private Map<String, ClientStatisticsHolder> globalClientStats = new ConcurrentHashMap<String, ClientStatisticsHolder>();

    private Client(Set<String> endpoints, Map<String, String> configuration) {
        this.endpoints = endpoints;
        this.configuration = configuration;
        this.endpoints.forEach(endpoint -> this.serverNodes.add(ClickHouseNode.of((String)endpoint, this.configuration)));
        this.serializers = new HashMap();
        this.getterMethods = new HashMap();
        this.hasDefaults = new HashMap();
        int numThreads = Integer.parseInt(configuration.getOrDefault(ClickHouseClientOption.MAX_THREADS_PER_CLIENT.getKey(), "3"));
        this.queryExecutor = Executors.newFixedThreadPool(numThreads, r -> {
            Thread t = new Thread(r);
            t.setName("ClickHouse-Query-Executor");
            t.setUncaughtExceptionHandler((t1, e) -> LOG.error("Uncaught exception in thread {}", (Object)t1.getName(), (Object)e));
            return t;
        });
        LOG.debug("Query executor created with {} threads", (Object)numThreads);
    }

    public String getDefaultDatabase() {
        return this.configuration.get("database");
    }

    private ClickHouseNode getServerNode() {
        return this.serverNodes.get(0);
    }

    public boolean ping() {
        return this.ping(TIMEOUT);
    }

    public boolean ping(long timeout) {
        ValidationUtils.checkRange(timeout, TimeUnit.SECONDS.toMillis(1L), TimeUnit.MINUTES.toMillis(10L), "timeout");
        try (ClickHouseClient client = ClientV1AdaptorHelper.createClient(this.configuration);){
            boolean bl = client.ping(this.getServerNode(), Math.toIntExact(timeout));
            return bl;
        }
    }

    public void register(Class<?> clazz, TableSchema schema) {
        LOG.debug("Registering POJO: {}", (Object)clazz.getName());
        ArrayList<POJOSerializer> serializers = new ArrayList<POJOSerializer>();
        HashMap<String, Method> getterMethods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.startsWith("get") || methodName.startsWith("has")) {
                methodName = methodName.substring(3).toLowerCase();
                getterMethods.put(methodName, method);
            }
            if (!methodName.startsWith("is")) continue;
            methodName = methodName.substring(2).toLowerCase();
            getterMethods.put(methodName, method);
        }
        this.getterMethods.put(clazz, getterMethods);
        for (ClickHouseColumn column : schema.getColumns()) {
            String columnName = column.getColumnName().toLowerCase().replace("_", "").replace(".", "");
            serializers.add((obj, stream) -> {
                if (!getterMethods.containsKey(columnName)) {
                    LOG.warn("No getter method found for column: {}", (Object)columnName);
                    return;
                }
                Method getterMethod = this.getterMethods.get(clazz).get(columnName);
                Object value = getterMethod.invoke(obj, new Object[0]);
                boolean hasDefaults = this.hasDefaults.get(clazz);
                if (value == null) {
                    if (hasDefaults && !column.hasDefault()) {
                        BinaryStreamUtils.writeNonNull((OutputStream)stream);
                    }
                    BinaryStreamUtils.writeNull((OutputStream)stream);
                    return;
                }
                if (hasDefaults) {
                    BinaryStreamUtils.writeNonNull((OutputStream)stream);
                }
                if (column.isNullable()) {
                    BinaryStreamUtils.writeNonNull((OutputStream)stream);
                }
                SerializerUtils.serializeData(stream, value, column);
            });
        }
        this.serializers.put(clazz, serializers);
        this.hasDefaults.put(clazz, schema.hasDefaults());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data) {
        return this.insert(tableName, data, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, List<?> data, InsertSettings settings) {
        boolean hasDefaults;
        String operationId = this.startOperation();
        settings.setOperationId(operationId);
        this.globalClientStats.get(operationId).start(ClientMetrics.OP_SERIALIZATION);
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be empty");
        }
        if (settings == null) {
            settings = new InsertSettings();
        }
        ClickHouseFormat format = (hasDefaults = this.hasDefaults.get(data.get(0).getClass()).booleanValue()) ? ClickHouseFormat.RowBinaryWithDefaults : ClickHouseFormat.RowBinary;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        List<POJOSerializer> serializers = this.serializers.get(data.get(0).getClass());
        if (serializers == null || serializers.isEmpty()) {
            throw new SerializerNotFoundException(data.get(0).getClass());
        }
        for (Object obj : data) {
            for (POJOSerializer serializer : serializers) {
                try {
                    serializer.serialize(obj, stream);
                }
                catch (IOException | IllegalAccessException | InvocationTargetException e) {
                    throw new DataSerializationException(obj, serializer, e);
                }
            }
        }
        this.globalClientStats.get(operationId).stop(ClientMetrics.OP_SERIALIZATION);
        LOG.debug("Total serialization time: {}", (Object)this.globalClientStats.get(operationId).getElapsedTime("serialization"));
        return this.insert(tableName, new ByteArrayInputStream(stream.toByteArray()), format, settings);
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format) {
        return this.insert(tableName, data, format, new InsertSettings());
    }

    public CompletableFuture<InsertResponse> insert(String tableName, InputStream data, ClickHouseFormat format, InsertSettings settings) {
        String operationId = settings.getOperationId();
        if (operationId == null) {
            operationId = this.startOperation();
            settings.setOperationId(operationId);
        }
        ClientStatisticsHolder clientStats = this.globalClientStats.remove(operationId);
        clientStats.start(ClientMetrics.OP_DURATION);
        CompletableFuture<InsertResponse> responseFuture = new CompletableFuture<InsertResponse>();
        try (ClickHouseClient client = ClientV1AdaptorHelper.createClient(this.configuration);){
            ClickHouseRequest.Mutation request = ClientV1AdaptorHelper.createMutationRequest(client.write(this.getServerNode()), tableName, settings, this.configuration).format(format);
            CompletableFuture future = null;
            try (ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)request.getConfig());){
                int bytesRead;
                future = request.data(stream.getInputStream()).execute();
                byte[] buffer = new byte[settings.getInputStreamCopyBufferSize()];
                while ((bytesRead = data.read(buffer)) != -1) {
                    stream.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                responseFuture.completeExceptionally(new ClientException("Failed to write data to the output stream", e));
            }
            if (!responseFuture.isCompletedExceptionally()) {
                try {
                    InsertResponse response = new InsertResponse(client, (ClickHouseResponse)future.get(), clientStats);
                    responseFuture.complete(response);
                }
                catch (InterruptedException | ExecutionException e) {
                    responseFuture.completeExceptionally(new ClientException("Operation has likely timed out.", e));
                }
            }
            LOG.debug("Total insert (InputStream) time: {}", (Object)clientStats.getElapsedTime("insert"));
        }
        return responseFuture;
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery) {
        return this.query(sqlQuery, null, null);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, QuerySettings settings) {
        return this.query(sqlQuery, null, settings);
    }

    public CompletableFuture<QueryResponse> query(String sqlQuery, Map<String, Object> queryParams, QuerySettings settings) {
        if (settings == null) {
            settings = new QuerySettings();
        }
        if (settings.getFormat() == null) {
            settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        }
        ClientStatisticsHolder clientStats = new ClientStatisticsHolder();
        clientStats.start(ClientMetrics.OP_DURATION);
        ClickHouseClient client = ClientV1AdaptorHelper.createClient(this.configuration);
        ClickHouseRequest request = client.read(this.getServerNode());
        request.options(SettingsConverter.toRequestOptions(settings.getAllSettings()));
        request.settings(SettingsConverter.toRequestSettings(settings.getAllSettings(), queryParams));
        request.query(sqlQuery, settings.getQueryId());
        ClickHouseFormat format = settings.getFormat();
        request.format(format);
        QuerySettings finalSettings = settings;
        CompletableFuture<QueryResponse> future = CompletableFuture.supplyAsync(() -> {
            LOG.trace("Executing request: {}", (Object)request);
            try {
                QueryResponse queryResponse = new QueryResponse(client, request.execute(), finalSettings, format, clientStats);
                queryResponse.ensureDone();
                return queryResponse;
            }
            catch (ClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Failed to get query response", e);
            }
        }, this.queryExecutor);
        return future;
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery) {
        return this.queryRecords(sqlQuery, null);
    }

    public CompletableFuture<Records> queryRecords(String sqlQuery, QuerySettings settings) {
        if (settings == null) {
            settings = new QuerySettings();
        }
        settings.setFormat(ClickHouseFormat.RowBinaryWithNamesAndTypes);
        ClientStatisticsHolder clientStats = new ClientStatisticsHolder();
        clientStats.start("query");
        ClickHouseClient client = ClientV1AdaptorHelper.createClient(this.configuration);
        ClickHouseRequest request = client.read(this.getServerNode());
        request.options(SettingsConverter.toRequestOptions(settings.getAllSettings()));
        request.settings(SettingsConverter.toRequestSettings(settings.getAllSettings(), null));
        request.query(sqlQuery, settings.getQueryId());
        ClickHouseFormat format = settings.getFormat();
        request.format(format);
        QuerySettings finalSettings = settings;
        CompletableFuture<Records> future = CompletableFuture.supplyAsync(() -> {
            LOG.trace("Executing request: {}", (Object)request);
            try {
                QueryResponse queryResponse = new QueryResponse(client, request.execute(), finalSettings, format, clientStats);
                queryResponse.ensureDone();
                return new Records(queryResponse, finalSettings);
            }
            catch (ClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Failed to get query response", e);
            }
        }, this.queryExecutor);
        return future;
    }

    public List<GenericRecord> queryAll(String sqlQuery) {
        ArrayList<GenericRecord> arrayList;
        block10: {
            QueryResponse response = this.query(sqlQuery).get(TIMEOUT, TimeUnit.MILLISECONDS);
            try {
                ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
                if (response.getResultRows() > 0L) {
                    RowBinaryWithNamesAndTypesFormatReader reader = new RowBinaryWithNamesAndTypesFormatReader((InputStream)response.getInputStream());
                    while (reader.hasNext()) {
                        records.add(new MapBackedRecord(reader.next(), reader.getSchema()));
                    }
                }
                arrayList = records;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClientException("Failed to get query response", e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    public TableSchema getTableSchema(String table) {
        return this.getTableSchema(table, this.configuration.get("database"));
    }

    public TableSchema getTableSchema(String table, String database) {
        try (ClickHouseClient clientQuery = ClientV1AdaptorHelper.createClient(this.configuration);){
            ClickHouseRequest request = clientQuery.read(this.getServerNode());
            request.query("DESCRIBE TABLE " + table + " FORMAT " + ClickHouseFormat.TSKV.name());
            try {
                TableSchema tableSchema = new TableSchemaParser().createFromBinaryResponse((ClickHouseResponse)clientQuery.execute(request).get(), table, database);
                return tableSchema;
            }
            catch (Exception e) {
                throw new ClientException("Failed to get table schema", e);
            }
        }
    }

    public CompletableFuture<CommandResponse> execute(String sql, CommandSettings settings) {
        return this.query(sql, settings).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    public CompletableFuture<CommandResponse> execute(String sql) {
        return this.query(sql).thenApplyAsync(response -> {
            try {
                return new CommandResponse((QueryResponse)response);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get command response", e);
            }
        });
    }

    private String startOperation() {
        String operationId = UUID.randomUUID().toString();
        this.globalClientStats.put(operationId, new ClientStatisticsHolder());
        return operationId;
    }

    public String toString() {
        return "Client{endpoints=" + this.endpoints + '}';
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public Set<String> getEndpoints() {
        return Collections.unmodifiableSet(this.endpoints);
    }

    public static class Builder {
        private Set<String> endpoints = new HashSet<String>();
        private Map<String, String> configuration = new HashMap<String, String>();

        public Builder() {
            this.setConnectTimeout(30L, ChronoUnit.SECONDS).setSocketTimeout(2L, ChronoUnit.SECONDS).setSocketRcvbuf(804800L).setSocketSndbuf(804800L).compressServerResponse(true).compressClientRequest(false);
        }

        public Builder addEndpoint(String endpoint) {
            try {
                URL endpointURL = new URL(endpoint);
                if (!endpointURL.getProtocol().equalsIgnoreCase("https") && !endpointURL.getProtocol().equalsIgnoreCase("http")) {
                    throw new IllegalArgumentException("Only HTTP and HTTPS protocols are supported");
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Endpoint should be a valid URL string", e);
            }
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder addEndpoint(Protocol protocol, String host, int port, boolean secure) {
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkNotNull((Object)protocol, "protocol");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            if (secure) {
                this.configuration.put(ClickHouseClientOption.SSL.getKey(), "true");
            }
            String endpoint = String.format("%s%s://%s:%d", protocol.toString().toLowerCase(), secure ? "s" : "", host, port);
            this.addEndpoint(endpoint);
            return this;
        }

        public Builder setOption(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Builder setUsername(String username) {
            this.configuration.put("user", username);
            return this;
        }

        public Builder setPassword(String password) {
            this.configuration.put("password", password);
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.configuration.put("access_token", accessToken);
            return this;
        }

        public Builder setConnectTimeout(long timeout) {
            this.configuration.put("connect_timeout", String.valueOf(timeout));
            return this;
        }

        public Builder setConnectTimeout(long timeout, ChronoUnit unit) {
            return this.setConnectTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setSocketTimeout(long timeout) {
            this.configuration.put("socket_timeout", String.valueOf(timeout));
            return this;
        }

        public Builder setSocketTimeout(long timeout, ChronoUnit unit) {
            return this.setSocketTimeout(Duration.of(timeout, unit).toMillis());
        }

        public Builder setSocketRcvbuf(long size) {
            this.configuration.put("socket_rcvbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketSndbuf(long size) {
            this.configuration.put("socket_sndbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketReuseAddress(boolean value) {
            this.configuration.put("socket_reuseaddr", String.valueOf(value));
            return this;
        }

        public Builder setSocketKeepAlive(boolean value) {
            this.configuration.put("socket_keepalive", String.valueOf(value));
            return this;
        }

        public Builder setSocketTcpNodelay(boolean value) {
            this.configuration.put("socket_tcp_nodelay", String.valueOf(value));
            return this;
        }

        public Builder setSocketLinger(int secondsToWait) {
            this.configuration.put("socket_linger", String.valueOf(secondsToWait));
            return this;
        }

        public Builder compressServerResponse(boolean enabled) {
            this.configuration.put("compress", String.valueOf(enabled));
            return this;
        }

        public Builder compressClientRequest(boolean enabled) {
            this.configuration.put("decompress", String.valueOf(enabled));
            return this;
        }

        public Builder setDefaultDatabase(String database) {
            this.configuration.put("database", database);
            return this;
        }

        public Builder addProxy(ProxyType type, String host, int port) {
            ValidationUtils.checkNotNull((Object)type, "type");
            ValidationUtils.checkNonBlank(host, "host");
            ValidationUtils.checkRange(port, 1, 65535, "port");
            this.configuration.put(ClickHouseClientOption.PROXY_TYPE.getKey(), type.toString());
            this.configuration.put(ClickHouseClientOption.PROXY_HOST.getKey(), host);
            this.configuration.put(ClickHouseClientOption.PROXY_PORT.getKey(), String.valueOf(port));
            return this;
        }

        public Client build() {
            if (this.endpoints.isEmpty()) {
                throw new IllegalArgumentException("At least one endpoint is required");
            }
            if (!(this.configuration.containsKey("access_token") || this.configuration.containsKey("user") && this.configuration.containsKey("password"))) {
                throw new IllegalArgumentException("Username and password are required");
            }
            if (!this.configuration.containsKey("database")) {
                this.configuration.put("database", Client.DEFAULT_DB_NAME);
            }
            return new Client(this.endpoints, this.configuration);
        }
    }
}

