/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NativeFormatReader
extends AbstractBinaryFormatReader {
    private Block currentBlock;
    private int blockRowIndex;

    public NativeFormatReader(InputStream inputStream, QuerySettings settings) {
        super(inputStream, settings, null);
    }

    @Override
    protected void readRecord(Map<String, Object> record) throws IOException {
        if (this.currentBlock == null || this.blockRowIndex >= this.currentBlock.getnRows()) {
            this.readBlock();
        }
        this.currentBlock.fillRecord(this.blockRowIndex, record);
        ++this.blockRowIndex;
    }

    private void readBlock() throws IOException {
        int nColumns = this.chInputStream.readVarInt();
        int nRows = this.chInputStream.readVarInt();
        ArrayList<String> names = new ArrayList<String>(nColumns);
        ArrayList<String> types = new ArrayList<String>(nColumns);
        this.currentBlock = new Block(names, types, nRows);
        for (int i = 0; i < nColumns; ++i) {
            ClickHouseColumn column = ClickHouseColumn.of((String)this.chInputStream.readUnicodeString(), (String)this.chInputStream.readUnicodeString());
            names.add(column.getColumnName());
            types.add(column.getDataType().name());
            ArrayList<Object> values = new ArrayList<Object>(nRows);
            for (int j = 0; j < nRows; ++j) {
                Object value = this.binaryStreamReader.readValue(column);
                values.add(value);
            }
            this.currentBlock.add(values);
        }
        this.blockRowIndex = 0;
    }

    @Override
    public <T> T readValue(int colIndex) {
        return (T)this.currentRecord.get(this.getSchema().indexToName(colIndex));
    }

    @Override
    public <T> T readValue(String colName) {
        return (T)this.currentRecord.get(colName);
    }

    @Override
    public boolean next() {
        if (this.hasNext) {
            try {
                this.readRecord(this.currentRecord);
            }
            catch (EOFException e) {
                this.hasNext = false;
                return false;
            }
            catch (IOException e) {
                throw new ClientException("Failed to read next block", e);
            }
        }
        return false;
    }

    private static class Block {
        final List<String> names;
        final List<String> types;
        final List<List<Object>> values = new ArrayList<List<Object>>();
        final int nRows;

        Block(List<String> names, List<String> types, int nRows) {
            this.names = names;
            this.types = types;
            this.nRows = nRows;
        }

        public void add(List<Object> values) {
            this.values.add(values);
        }

        public int getnRows() {
            return this.nRows;
        }

        private void fillRecord(int index, Map<String, Object> record) {
            int colIndex = 0;
            for (String name : this.names) {
                record.put(name, this.values.get(colIndex).get(index));
                ++colIndex;
            }
        }
    }
}

