/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.logging;

import com.clickhouse.logging.LogMessage;
import com.clickhouse.logging.Logger;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Level;

public class JdkLogger
implements Logger {
    private final java.util.logging.Logger logger;

    protected void log(Level level, LogMessage msg) {
        if (msg.hasThrowable()) {
            this.logger.logrb(level, (String)null, (String)null, (ResourceBundle)null, msg.getMessage(), msg.getThrowable());
        } else {
            this.logger.logrb(level, (String)null, (String)null, (ResourceBundle)null, msg.getMessage(), new Object[0]);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public JdkLogger(java.util.logging.Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Non-null logger is required");
        }
        this.logger = logger;
    }

    @Override
    public void debug(Supplier<?> function) {
        if (function != null && this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, LogMessage.of(function.get(), new Object[0]));
        }
    }

    @Override
    public void debug(Object format, Object ... arguments) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, LogMessage.of(format, arguments));
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logrb(Level.FINE, (String)null, (String)null, (ResourceBundle)null, String.valueOf(message), t);
        }
    }

    @Override
    public void error(Supplier<?> function) {
        if (function != null && this.logger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, LogMessage.of(function.get(), new Object[0]));
        }
    }

    @Override
    public void error(Object format, Object ... arguments) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, LogMessage.of(format, arguments));
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.logrb(Level.SEVERE, (String)null, (String)null, (ResourceBundle)null, String.valueOf(message), t);
        }
    }

    @Override
    public void info(Supplier<?> function) {
        if (function != null && this.logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, LogMessage.of(function.get(), new Object[0]));
        }
    }

    @Override
    public void info(Object format, Object ... arguments) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, LogMessage.of(format, arguments));
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.logrb(Level.INFO, (String)null, (String)null, (ResourceBundle)null, String.valueOf(message), t);
        }
    }

    @Override
    public void trace(Supplier<?> function) {
        if (function != null && this.logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, LogMessage.of(function.get(), new Object[0]));
        }
    }

    @Override
    public void trace(Object format, Object ... arguments) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, LogMessage.of(format, arguments));
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.logrb(Level.FINEST, (String)null, (String)null, (ResourceBundle)null, String.valueOf(message), t);
        }
    }

    @Override
    public void warn(Supplier<?> function) {
        if (function != null && this.logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, LogMessage.of(function.get(), new Object[0]));
        }
    }

    @Override
    public void warn(Object format, Object ... arguments) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, LogMessage.of(format, arguments));
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.logrb(Level.WARNING, (String)null, (String)null, (ResourceBundle)null, String.valueOf(message), t);
        }
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

