/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.stream.AbstractByteBufferInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class IterableByteBufferInputStream
extends AbstractByteBufferInputStream {
    private final Iterator<ByteBuffer> it;

    public IterableByteBufferInputStream(Iterable<ByteBuffer> source, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.it = ClickHouseChecker.nonNull(source, "Source").iterator();
    }

    @Override
    protected int updateBuffer() throws IOException {
        while (this.it.hasNext()) {
            ByteBuffer bytes = this.it.next();
            if (bytes == null || !bytes.hasRemaining()) continue;
            this.buffer = bytes;
            if (this.copyTo != null) {
                int position = bytes.position();
                if (bytes.hasArray()) {
                    this.copyTo.write(bytes.array(), position, bytes.remaining());
                } else {
                    byte[] b = new byte[bytes.remaining()];
                    bytes.get(b);
                    this.copyTo.write(b);
                    ((Buffer)bytes).position(position);
                }
            }
            return bytes.remaining();
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BUFFER;
        return 0;
    }
}

