/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseDnsResolver;
import com.clickhouse.client.ClickHouseNodeManager;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ClickHouseNode
implements Function<ClickHouseNodeSelector, ClickHouseNode>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseNode.class);
    private static final long serialVersionUID = 8342604784121795372L;
    private static final Map<String, URI> cache = Collections.synchronizedMap(new WeakHashMap());
    static final ClickHouseNode DEFAULT = new ClickHouseNode("localhost", ClickHouseProtocol.ANY, 0, null, null, null);
    static final int MAX_PORT_NUM = 65535;
    static final int MIN_PORT_NUM = 0;
    static final String PARAM_CLUSTER = "cluster";
    static final String PARAM_SHARD_NUM = "shard_num";
    static final String PARAM_SHARD_WEIGHT = "shard_weight";
    static final String PARAM_REPLICA_NUM = "replica_num";
    static final String PARAM_WEIGHT = "weight";
    static final int DEFAULT_SHARD_NUM = 0;
    static final int DEFAULT_SHARD_WEIGHT = 0;
    static final int DEFAULT_REPLICA_NUM = 0;
    static final int DEFAULT_WEIGHT = 1;
    public static final String SCHEME_DELIMITER = "://";
    private final String host;
    private final ClickHouseProtocol protocol;
    private final int port;
    private final ClickHouseCredentials credentials;
    private final Map<String, String> options;
    private final Set<String> tags;
    private final String cluster;
    private final int replicaNum;
    private final int shardNum;
    private final int shardWeight;
    private final int weight;
    private final String baseUri;
    protected final AtomicLong lastUpdateTime;
    protected final ClickHouseConfig config;
    protected final AtomicReference<ClickHouseNodeManager> manager;

    static int extract(String scheme, int port, ClickHouseProtocol protocol, Map<String, String> params) {
        if (port < 0 || port > 65535) {
            port = 0;
        }
        if (protocol != ClickHouseProtocol.POSTGRESQL && scheme.charAt(scheme.length() - 1) == 's') {
            params.putIfAbsent(ClickHouseClientOption.SSL.getKey(), Boolean.TRUE.toString());
            params.putIfAbsent(ClickHouseClientOption.SSL_MODE.getKey(), ClickHouseSslMode.STRICT.name());
        }
        if (protocol != ClickHouseProtocol.ANY && port == 0) {
            port = Boolean.TRUE.toString().equals(params.get(ClickHouseClientOption.SSL.getKey())) ? protocol.getDefaultSecurePort() : protocol.getDefaultPort();
        }
        return port;
    }

    static ClickHouseCredentials extract(String rawUserInfo, Map<String, String> params, ClickHouseCredentials defaultCredentials) {
        String str;
        ClickHouseCredentials credentials = defaultCredentials;
        String user = "";
        String passwd = "";
        if (credentials != null && !credentials.useAccessToken()) {
            user = credentials.getUserName();
            passwd = credentials.getPassword();
        }
        if (!ClickHouseChecker.isNullOrEmpty(rawUserInfo)) {
            int index = rawUserInfo.indexOf(58);
            if (index < 0) {
                user = ClickHouseUtils.decode(rawUserInfo);
            } else {
                String str2 = ClickHouseUtils.decode(rawUserInfo.substring(0, index));
                if (!ClickHouseChecker.isNullOrEmpty(str2)) {
                    user = str2;
                }
                passwd = ClickHouseUtils.decode(rawUserInfo.substring(index + 1));
            }
        }
        if (!ClickHouseChecker.isNullOrEmpty(str = params.remove(ClickHouseDefaults.USER.getKey()))) {
            user = str;
        }
        if ((str = params.remove(ClickHouseDefaults.PASSWORD.getKey())) != null) {
            passwd = str;
        }
        if (!ClickHouseChecker.isNullOrEmpty(user)) {
            credentials = ClickHouseCredentials.fromUserAndPassword(user, passwd);
        } else if (!ClickHouseChecker.isNullOrEmpty(passwd)) {
            credentials = ClickHouseCredentials.fromUserAndPassword((String)((Object)ClickHouseDefaults.USER.getEffectiveDefaultValue()), passwd);
        }
        return credentials;
    }

    static URI normalize(String uri, ClickHouseProtocol defaultProtocol) {
        int index = ClickHouseChecker.nonEmpty(uri, "URI").indexOf(SCHEME_DELIMITER);
        String normalized = index < 0 ? (defaultProtocol != null ? defaultProtocol : ClickHouseProtocol.ANY).name().toLowerCase(Locale.ROOT) + SCHEME_DELIMITER + uri.trim() : uri.trim();
        return cache.computeIfAbsent(normalized, k -> {
            try {
                return new URI((String)k);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI", e);
            }
        });
    }

    static void parseDatabase(String path, Map<String, String> params) {
        if (!ClickHouseChecker.isNullOrEmpty(path) && path.length() > 1) {
            params.put(ClickHouseClientOption.DATABASE.getKey(), path.substring(1));
        }
    }

    static void parseTags(String fragment, Set<String> tags) {
        if (ClickHouseChecker.isNullOrEmpty(fragment)) {
            return;
        }
        int len = fragment.length();
        for (int i = 0; i < len; ++i) {
            String tag;
            int index = fragment.indexOf(44, i);
            if (index == i) continue;
            if (index < 0) {
                tag = fragment.substring(i).trim();
                i = len;
            } else {
                tag = fragment.substring(i, index).trim();
                i = index;
            }
            if (tag.isEmpty()) continue;
            tags.add(tag);
        }
    }

    static ClickHouseNode probe(String host, int port, ClickHouseSslMode mode, String rootCaFile, String certFile, String keyFile, int timeout) {
        if (mode == null) {
            return ClickHouseNode.probe(host, port, timeout);
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        options.put(ClickHouseClientOption.SSL, Boolean.valueOf(true));
        options.put(ClickHouseClientOption.SSL_MODE, (Serializable)((Object)mode));
        options.put(ClickHouseClientOption.SSL_ROOT_CERTIFICATE, (Serializable)((Object)rootCaFile));
        options.put(ClickHouseClientOption.SSL_CERTIFICATE, (Serializable)((Object)certFile));
        options.put(ClickHouseClientOption.SSL_KEY, (Serializable)((Object)keyFile));
        ClickHouseConfig config = new ClickHouseConfig(options);
        SSLContext sslContext = null;
        try {
            sslContext = ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, config).orElse(null);
        }
        catch (SSLException e) {
            log.debug((Object)"Failed to create SSL context due to: %s", e.getMessage());
        }
        if (sslContext == null) {
            return ClickHouseNode.probe(host, port, timeout);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        ClickHouseDnsResolver resolver = ClickHouseDnsResolver.getInstance();
        ClickHouseProtocol p = ClickHouseProtocol.HTTP;
        InetSocketAddress address = resolver != null ? resolver.resolve(ClickHouseProtocol.ANY, host, port) : new InetSocketAddress(host, port);
        try (SSLSocket client = (SSLSocket)factory.createSocket();){
            client.setKeepAlive(false);
            client.setSoTimeout(timeout);
            client.connect(address, timeout);
            client.startHandshake();
            try (OutputStream out = client.getOutputStream();
                 InputStream in = client.getInputStream();){
                out.write("GET /ping HTTP/1.1\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
                out.flush();
                byte[] buf = new byte[12];
                int read = in.read(buf);
                if (read == -1) {
                    p = ClickHouseProtocol.GRPC;
                } else if (buf[0] == 72 && buf[9] == 52) {
                    p = ClickHouseProtocol.TCP;
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to probe %s:%d", host, port, e);
        }
        return new ClickHouseNode(host, p, port, null, null, null);
    }

    static ClickHouseNode probe(String host, int port, int timeout) {
        ClickHouseDnsResolver resolver = ClickHouseDnsResolver.getInstance();
        InetSocketAddress address = resolver != null ? resolver.resolve(ClickHouseProtocol.ANY, host, port) : new InetSocketAddress(host, port);
        ClickHouseProtocol p = ClickHouseProtocol.HTTP;
        try (Socket client = new Socket();){
            client.setKeepAlive(false);
            client.connect(address, timeout);
            client.setSoTimeout(timeout);
            try (OutputStream out = client.getOutputStream();
                 InputStream in = client.getInputStream();){
                out.write("GET /ping HTTP/1.1\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
                out.flush();
                byte[] buf = new byte[12];
                int read = in.read(buf);
                if (read == buf.length && buf[0] == 0) {
                    p = ClickHouseProtocol.GRPC;
                } else if (buf[0] != 0 && buf[3] == 0) {
                    p = ClickHouseProtocol.MYSQL;
                } else if (buf[0] == 72 && buf[9] == 52) {
                    p = ClickHouseProtocol.TCP;
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to probe %s:%d", host, port, e);
        }
        return new ClickHouseNode(host, p, port, null, null, null);
    }

    static String value(String value, String defaultValue) {
        return ClickHouseChecker.isNullOrEmpty(value) ? defaultValue : value;
    }

    static int value(String value, int defaultValue) {
        return ClickHouseChecker.isNullOrEmpty(value) ? defaultValue : Integer.parseInt(value);
    }

    public static Builder builder() {
        return ClickHouseNode.builder(null);
    }

    public static Builder builder(ClickHouseNode base) {
        Builder b = new Builder();
        if (base != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(base.options);
            map.put(PARAM_CLUSTER, base.getCluster());
            map.put(PARAM_REPLICA_NUM, Integer.toString(base.replicaNum));
            map.put(PARAM_SHARD_NUM, Integer.toString(base.shardNum));
            map.put(PARAM_SHARD_WEIGHT, Integer.toString(base.shardWeight));
            map.put(PARAM_WEIGHT, Integer.toString(base.getWeight()));
            b.host(base.getHost()).port(base.getProtocol(), base.getPort()).credentials(base.credentials).options(map).tags(base.getTags());
        }
        return b;
    }

    public static ClickHouseNode of(String host, ClickHouseProtocol protocol, int port, String database, String ... tags) {
        Builder builder = ClickHouseNode.builder().host(host).port(protocol, port).database(database);
        if (tags != null && tags.length > 0) {
            builder.tags(null, tags);
        }
        return builder.build();
    }

    public static ClickHouseNode of(String uri) {
        return ClickHouseNode.of(uri, DEFAULT);
    }

    public static ClickHouseNode of(String uri, Map<?, ?> options) {
        URI normalizedUri = ClickHouseNode.normalize(uri, null);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ClickHouseNode.parseDatabase(normalizedUri.getPath(), params);
        ClickHouseUtils.extractParameters(normalizedUri.getRawQuery(), params);
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        ClickHouseNode.parseTags(normalizedUri.getRawFragment(), tags);
        if (options != null && !options.isEmpty()) {
            for (Map.Entry<?, ?> entry : options.entrySet()) {
                if (entry.getKey() == null) continue;
                if (entry.getValue() != null) {
                    params.put(entry.getKey().toString(), entry.getValue().toString());
                    continue;
                }
                params.remove(entry.getKey().toString());
            }
        }
        String scheme = normalizedUri.getScheme();
        ClickHouseProtocol protocol = ClickHouseProtocol.fromUriScheme(scheme);
        int port = ClickHouseNode.extract(scheme, normalizedUri.getPort(), protocol, params);
        ClickHouseCredentials credentials = ClickHouseNode.extract(normalizedUri.getRawUserInfo(), params, null);
        return new ClickHouseNode(normalizedUri.getHost(), protocol, port, credentials, params, tags);
    }

    public static ClickHouseNode of(String uri, ClickHouseNode template) {
        return ClickHouseNode.of(ClickHouseNode.normalize(uri, template != null ? template.getProtocol() : null), template);
    }

    public static ClickHouseNode of(URI uri, ClickHouseNode template) {
        String host = ClickHouseChecker.nonNull(uri, "URI").getHost();
        String scheme = ClickHouseChecker.nonEmpty(uri.getScheme(), "Protocol");
        if (template == null) {
            template = DEFAULT;
        }
        if (ClickHouseChecker.isNullOrEmpty(host)) {
            host = template.getHost();
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(template.options);
        ClickHouseNode.parseDatabase(uri.getPath(), params);
        ClickHouseUtils.extractParameters(uri.getRawQuery(), params);
        ClickHouseProtocol protocol = ClickHouseProtocol.fromUriScheme(scheme);
        int port = ClickHouseNode.extract(scheme, uri.getPort(), protocol, params);
        ClickHouseCredentials credentials = ClickHouseNode.extract(uri.getRawUserInfo(), params, template.credentials);
        LinkedHashSet<String> tags = new LinkedHashSet<String>(template.tags);
        ClickHouseNode.parseTags(uri.getRawFragment(), tags);
        for (String key : new String[]{ClickHouseClientOption.LOAD_BALANCING_POLICY.getKey(), ClickHouseClientOption.LOAD_BALANCING_TAGS.getKey(), ClickHouseClientOption.FAILOVER.getKey(), ClickHouseClientOption.NODE_DISCOVERY_INTERVAL.getKey(), ClickHouseClientOption.NODE_DISCOVERY_LIMIT.getKey(), ClickHouseClientOption.HEALTH_CHECK_INTERVAL.getKey(), ClickHouseClientOption.NODE_GROUP_SIZE.getKey(), ClickHouseClientOption.CHECK_ALL_NODES.getKey()}) {
            if (!template.options.containsKey(key)) continue;
            params.remove(key);
        }
        return new ClickHouseNode(host, protocol, port, credentials, params, tags);
    }

    protected ClickHouseNode(Builder builder) {
        this(ClickHouseChecker.nonNull(builder, "builder").getHost(), builder.getProtocol(), builder.getPort(), builder.getCredentials(), builder.getOptions(), builder.getTags());
    }

    protected ClickHouseNode(String host, ClickHouseProtocol protocol, int port, ClickHouseCredentials credentials, Map<String, String> options, Set<String> tags) {
        this.host = ClickHouseChecker.nonEmpty(host, "Host");
        this.protocol = protocol != null ? protocol : ClickHouseProtocol.ANY;
        this.port = port < 0 || port > 65535 ? this.protocol.getDefaultPort() : port;
        this.credentials = credentials;
        if (options != null && !options.isEmpty()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(options);
            this.cluster = ClickHouseNode.value((String)map.remove(PARAM_CLUSTER), "");
            this.replicaNum = ClickHouseNode.value((String)map.remove(PARAM_REPLICA_NUM), 0);
            this.shardNum = ClickHouseNode.value((String)map.remove(PARAM_SHARD_NUM), 0);
            this.shardWeight = ClickHouseNode.value((String)map.remove(PARAM_SHARD_WEIGHT), 0);
            this.weight = ClickHouseNode.value((String)map.remove(PARAM_WEIGHT), 1);
            this.options = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        } else {
            this.cluster = "";
            this.replicaNum = 0;
            this.shardNum = 0;
            this.shardWeight = 0;
            this.weight = 1;
            this.options = Collections.emptyMap();
        }
        this.lastUpdateTime = new AtomicLong(0L);
        this.tags = tags == null || tags.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(tags));
        this.config = new ClickHouseConfig(ClickHouseConfig.toClientOptions(options), credentials, null, null);
        this.manager = new AtomicReference<Object>(null);
        StringBuilder builder = new StringBuilder().append(this.protocol.name().toLowerCase(Locale.ROOT));
        if (this.config.isSsl()) {
            builder.append('s');
        }
        builder.append(SCHEME_DELIMITER);
        builder.append(host).append(':').append(port).append('/');
        this.baseUri = builder.toString();
    }

    protected ClickHouseNode probe() {
        if (this.protocol != ClickHouseProtocol.ANY) {
            return this;
        }
        ClickHouseNode newNode = this.config.isSsl() ? ClickHouseNode.probe(this.host, this.port, this.config.getSslMode(), this.config.getSslRootCert(), this.config.getSslCert(), this.config.getSslKey(), this.config.getConnectionTimeout()) : ClickHouseNode.probe(this.host, this.port, this.config.getConnectionTimeout());
        return newNode;
    }

    protected ClickHouseNode setManager(ClickHouseNodeManager m) {
        this.manager.getAndUpdate(v -> {
            boolean sameManager = Objects.equals(v, m);
            if (v != null && !sameManager) {
                v.update(this, Status.STANDALONE);
            }
            return sameManager ? v : null;
        });
        if (m != null && this.manager.compareAndSet(null, m)) {
            m.update(this, Status.MANAGED);
        }
        return this;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public ClickHouseConfig getConfig() {
        return this.config;
    }

    public Optional<ClickHouseCredentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public ClickHouseCredentials getCredentials(ClickHouseConfig config) {
        return this.credentials != null ? this.credentials : ClickHouseChecker.nonNull(config, "Config").getDefaultCredentials();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Optional<String> getDatabase() {
        return this.hasPreferredDatabase() ? Optional.of(this.config.getDatabase()) : Optional.empty();
    }

    public String getDatabase(ClickHouseConfig config) {
        return !ClickHouseChecker.nonNull(config, "Config").hasOption(ClickHouseClientOption.DATABASE) && this.hasPreferredDatabase() ? this.config.getDatabase() : config.getDatabase();
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getWeight() {
        return this.weight;
    }

    public Optional<TimeZone> getTimeZone() {
        return this.config.hasOption(ClickHouseClientOption.SERVER_TIME_ZONE) ? Optional.of(this.config.getServerTimeZone()) : Optional.empty();
    }

    public TimeZone getTimeZone(ClickHouseConfig config) {
        return this.config.hasOption(ClickHouseClientOption.SERVER_TIME_ZONE) ? this.config.getServerTimeZone() : ClickHouseChecker.nonNull(config, "Config").getServerTimeZone();
    }

    public Optional<ClickHouseVersion> getVersion() {
        return this.config.hasOption(ClickHouseClientOption.SERVER_VERSION) ? Optional.of(this.config.getServerVersion()) : Optional.empty();
    }

    public ClickHouseVersion getVersion(ClickHouseConfig config) {
        return this.config.hasOption(ClickHouseClientOption.SERVER_VERSION) ? this.config.getServerVersion() : ClickHouseChecker.nonNull(config, "Config").getServerVersion();
    }

    public String getCluster() {
        return this.cluster;
    }

    public ClickHouseProtocol getProtocol() {
        return this.protocol;
    }

    public boolean hasPreferredDatabase() {
        return this.config.hasOption(ClickHouseClientOption.DATABASE);
    }

    public boolean isManaged() {
        return this.manager.get() != null;
    }

    public boolean isStandalone() {
        return this.manager.get() == null;
    }

    public boolean isSameEndpoint(ClickHouseNode node) {
        if (node == null) {
            return false;
        }
        return this.baseUri.equals(node.baseUri);
    }

    public void update(Status status) {
        ClickHouseNodeManager m = this.manager.get();
        if (m != null) {
            m.update(this, status);
        }
    }

    @Override
    public ClickHouseNode apply(ClickHouseNodeSelector t) {
        ClickHouseNodeManager m = this.manager.get();
        if (m != null) {
            return (ClickHouseNode)m.apply(m.getNodeSelector());
        }
        if (!(t == null || t == ClickHouseNodeSelector.EMPTY || t.matchAnyOfPreferredProtocols(this.protocol) && t.matchAllPreferredTags(this.tags))) {
            throw new IllegalArgumentException(ClickHouseUtils.format("%s expects a node rather than %s", t, this));
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.protocol, this.credentials, this.options, this.tags, this.cluster, this.replicaNum, this.shardNum, this.shardWeight, this.weight});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseNode other = (ClickHouseNode)obj;
        return this.host.equals(other.host) && this.port == other.port && this.protocol == other.protocol && Objects.equals(this.credentials, other.credentials) && this.options.equals(other.options) && this.tags.equals(other.tags) && this.cluster.equals(other.cluster) && this.replicaNum == other.replicaNum && this.shardNum == other.shardNum && this.shardWeight == other.shardWeight && this.weight == other.weight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("ClickHouseNode [uri=").append(this.baseUri).append(this.config.getDatabase());
        if (!this.cluster.isEmpty()) {
            builder.append(", cluster=").append(this.cluster).append("(s").append(this.shardNum).append(",w").append(this.shardWeight).append(",r").append(this.replicaNum).append(')');
        }
        StringBuilder optsBuilder = new StringBuilder();
        for (Map.Entry<String, String> option : this.options.entrySet()) {
            String key = option.getKey();
            if (ClickHouseClientOption.DATABASE.getKey().equals(key) || ClickHouseClientOption.SSL.getKey().equals(key)) continue;
            optsBuilder.append(key).append('=').append(option.getValue()).append(",");
        }
        if (optsBuilder.length() > 0) {
            optsBuilder.setLength(optsBuilder.length() - 1);
            builder.append(", options={").append((CharSequence)optsBuilder).append('}');
        }
        if (!this.tags.isEmpty()) {
            builder.append(", tags=").append(this.tags);
        }
        return builder.append("]@").append(this.hashCode()).toString();
    }

    public URI toUri() {
        return this.toUri(null);
    }

    public URI toUri(String schemePrefix) {
        StringBuilder builder = new StringBuilder();
        String db = this.getDatabase().orElse(null);
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            if (ClickHouseClientOption.DATABASE.getKey().equals(entry.getKey())) {
                db = entry.getValue();
                continue;
            }
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        String query = null;
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
            query = builder.toString();
        }
        builder.setLength(0);
        boolean first = true;
        for (String tag : this.tags) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(ClickHouseUtils.encode(tag));
        }
        String p = this.protocol.name().toLowerCase(Locale.ROOT);
        schemePrefix = ClickHouseChecker.isNullOrEmpty(schemePrefix) ? p : (schemePrefix.charAt(schemePrefix.length() - 1) == ':' ? schemePrefix.concat(p) : schemePrefix + ':' + p);
        try {
            return new URI(schemePrefix, null, this.host, this.port, ClickHouseChecker.isNullOrEmpty(db) ? "" : "/".concat(db), query, builder.length() > 0 ? builder.toString() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder {
        protected String host = null;
        protected ClickHouseProtocol protocol = null;
        protected Integer port = null;
        protected ClickHouseCredentials credentials = null;
        protected final Map<String, String> options = new LinkedHashMap<String, String>();
        protected final Set<String> tags = new LinkedHashSet<String>();

        protected Builder() {
        }

        protected String getHost() {
            if (ClickHouseChecker.isNullOrEmpty(this.host)) {
                this.host = (String)((Object)ClickHouseDefaults.HOST.getEffectiveDefaultValue());
            }
            return this.host;
        }

        protected ClickHouseProtocol getProtocol() {
            if (this.protocol == null) {
                this.protocol = (ClickHouseProtocol)((Object)ClickHouseDefaults.PROTOCOL.getEffectiveDefaultValue());
            }
            return this.protocol;
        }

        protected int getPort() {
            if (this.port == null) {
                this.port = this.getProtocol().getDefaultPort();
            }
            return this.port;
        }

        protected ClickHouseCredentials getCredentials() {
            return this.credentials;
        }

        protected Map<String, String> getOptions() {
            return this.options;
        }

        protected Set<String> getTags() {
            return this.tags;
        }

        public Builder cluster(String cluster) {
            if (!ClickHouseChecker.isNullOrEmpty(cluster)) {
                this.options.put(ClickHouseNode.PARAM_CLUSTER, cluster);
            } else {
                this.options.remove(ClickHouseNode.PARAM_CLUSTER);
            }
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            return this.port(null, port);
        }

        public Builder port(ClickHouseProtocol protocol) {
            return this.port(protocol, null);
        }

        public Builder port(ClickHouseProtocol protocol, Integer port) {
            this.protocol = protocol;
            this.port = port;
            return this;
        }

        public Builder address(InetSocketAddress address) {
            return this.address(null, address);
        }

        public Builder address(ClickHouseProtocol protocol, InetSocketAddress address) {
            if (address != null) {
                this.host(address.getHostName());
                this.port(protocol, address.getPort());
            } else {
                this.host(null);
                this.port(protocol, null);
            }
            return this;
        }

        public Builder database(String database) {
            if (!ClickHouseChecker.isNullOrEmpty(database)) {
                this.options.put(ClickHouseClientOption.DATABASE.getKey(), database);
            } else {
                this.options.remove(ClickHouseClientOption.DATABASE.getKey());
            }
            return this;
        }

        public Builder credentials(ClickHouseCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder addOption(String option, String value) {
            if (option != null) {
                if (value != null) {
                    this.options.put(option, value);
                } else {
                    this.options.remove(option);
                }
            }
            return this;
        }

        public Builder removeOption(String option) {
            if (!ClickHouseChecker.isNullOrEmpty(option)) {
                this.options.remove(option);
            }
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options.clear();
            if (options != null) {
                this.options.putAll(options);
            }
            return this;
        }

        public Builder addTag(String tag) {
            if (!ClickHouseChecker.isNullOrEmpty(tag)) {
                this.tags.add(tag);
            }
            return this;
        }

        public Builder removeTag(String tag) {
            if (!ClickHouseChecker.isNullOrEmpty(tag)) {
                this.tags.remove(tag);
            }
            return this;
        }

        public Builder tags(String tag, String ... more) {
            this.tags.clear();
            this.addTag(tag);
            if (more != null) {
                for (String t : more) {
                    this.addTag(t);
                }
            }
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            if (tags != null) {
                for (String t : tags) {
                    this.addTag(t);
                }
            }
            return this;
        }

        public Builder replica(Integer num) {
            if (num != null) {
                this.options.put(ClickHouseNode.PARAM_REPLICA_NUM, num.toString());
            } else {
                this.options.remove(ClickHouseNode.PARAM_REPLICA_NUM);
            }
            return this;
        }

        public Builder shard(Integer num, Integer weight) {
            if (num != null) {
                this.options.put(ClickHouseNode.PARAM_SHARD_NUM, num.toString());
            } else {
                this.options.remove(ClickHouseNode.PARAM_SHARD_NUM);
            }
            if (weight != null) {
                this.options.put(ClickHouseNode.PARAM_SHARD_WEIGHT, weight.toString());
            } else {
                this.options.remove(ClickHouseNode.PARAM_SHARD_WEIGHT);
            }
            return this;
        }

        public Builder weight(Integer weight) {
            if (weight != null) {
                this.options.put(ClickHouseNode.PARAM_WEIGHT, weight.toString());
            } else {
                this.options.remove(ClickHouseNode.PARAM_WEIGHT);
            }
            return this;
        }

        public Builder timeZone(String tz) {
            if (!ClickHouseChecker.isNullOrEmpty(tz)) {
                this.options.put(ClickHouseClientOption.SERVER_TIME_ZONE.getKey(), tz);
            } else {
                this.options.remove(ClickHouseClientOption.SERVER_TIME_ZONE.getKey());
            }
            return this;
        }

        public Builder timeZone(TimeZone tz) {
            this.timeZone(tz != null ? tz.getID() : null);
            return this;
        }

        public Builder version(String version) {
            if (!ClickHouseChecker.isNullOrEmpty(version)) {
                this.options.put(ClickHouseClientOption.SERVER_VERSION.getKey(), version);
            } else {
                this.options.remove(ClickHouseClientOption.SERVER_VERSION.getKey());
            }
            return this;
        }

        public Builder version(ClickHouseVersion version) {
            this.version(version != null ? version.toString() : null);
            return this;
        }

        public ClickHouseNode build() {
            return new ClickHouseNode(this);
        }
    }

    public static enum Status {
        HEALTHY,
        MANAGED,
        FAULTY,
        STANDALONE;

    }
}

