/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public class ClickHouseJdbcUrlParser {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseJdbcUrlParser.class);
    public static final String PROP_JDBC_COMPLIANT = "jdbc_compliant";
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:clickhouse:";
    public static final String JDBC_ABBREVIATION_PREFIX = "jdbc:ch:";

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Failed to decode given string, fallback to the original string", new Object[0]);
            return str;
        }
    }

    private static ClickHouseNode parseNode(URI uri, Properties defaults) {
        String database;
        ClickHouseProtocol protocol = ClickHouseProtocol.fromUriScheme((String)uri.getScheme());
        if (protocol == null || protocol == ClickHouseProtocol.ANY) {
            throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
        }
        String host = uri.getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host is missed or wrong");
        }
        int port = uri.getPort();
        if (port == -1) {
            port = protocol.getDefaultPort();
        }
        String userName = defaults.getProperty(ClickHouseDefaults.USER.getKey());
        String password = defaults.getProperty(ClickHouseDefaults.PASSWORD.getKey());
        String userInfo = uri.getRawUserInfo();
        if (userInfo != null && !userInfo.isEmpty()) {
            int index = userInfo.indexOf(58);
            if (userName == null) {
                String string = index == 0 ? userName : (userName = ClickHouseJdbcUrlParser.decode(index > 0 ? userInfo.substring(0, index) : userInfo));
            }
            if (password == null) {
                String string = password = index < 0 ? password : ClickHouseJdbcUrlParser.decode(userInfo.substring(index + 1));
            }
        }
        if (userName == null || userName.isEmpty()) {
            userName = (String)((Object)ClickHouseDefaults.USER.getEffectiveDefaultValue());
        }
        if (password == null) {
            password = (String)((Object)ClickHouseDefaults.PASSWORD.getEffectiveDefaultValue());
        }
        String dbKey = ClickHouseDefaults.DATABASE.getKey();
        String path = uri.getPath();
        if (path == null || path.isEmpty() || path.equals("/")) {
            database = defaults.getProperty(dbKey);
        } else if (path.charAt(0) == '/') {
            database = defaults.getProperty(dbKey, path.substring(1));
        } else {
            throw new IllegalArgumentException("wrong database name path: '" + path + "'");
        }
        if (database == null || database.isEmpty()) {
            database = (String)((Object)ClickHouseDefaults.DATABASE.getEffectiveDefaultValue());
        }
        defaults.setProperty(dbKey, database);
        return ClickHouseNode.builder().host(host).port(protocol, Integer.valueOf(port)).database(database).credentials(ClickHouseCredentials.fromUserAndPassword((String)userName, (String)password)).build();
    }

    private static Properties parseParams(String query, Properties props) {
        String[] queryKeyValues;
        if (query == null || query.isEmpty()) {
            return props;
        }
        for (String keyValue : queryKeyValues = query.split("&")) {
            int index = keyValue.indexOf(61);
            if (index <= 0) {
                log.warn((Object)"don't know how to handle parameter pair: %s", new Object[]{keyValue});
                continue;
            }
            props.put(ClickHouseJdbcUrlParser.decode(keyValue.substring(0, index)), ClickHouseJdbcUrlParser.decode(keyValue.substring(index + 1)));
        }
        return props;
    }

    static String removeCredentialsFromQuery(String query) {
        if (query == null || query.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(query.length());
        int start = 0;
        int index = 0;
        do {
            String kv = query.substring(start, (index = query.indexOf(38, start)) < 0 ? query.length() : index);
            start += kv.length() + 1;
            int i = kv.indexOf(61);
            if (i <= 0) continue;
            String key = kv.substring(0, i);
            if (ClickHouseDefaults.USER.getKey().equals(key) || ClickHouseDefaults.PASSWORD.getKey().equals(key)) continue;
            builder.append(kv).append('&');
        } while (index >= 0);
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
            query = builder.toString();
        } else {
            query = null;
        }
        return query;
    }

    static Properties newProperties() {
        Properties props = new Properties();
        props.setProperty(ClickHouseClientOption.ASYNC.getKey(), Boolean.FALSE.toString());
        props.setProperty(ClickHouseClientOption.FORMAT.getKey(), ClickHouseFormat.RowBinaryWithNamesAndTypes.name());
        return props;
    }

    public static ConnectionInfo parse(String jdbcUrl, Properties defaults) throws URISyntaxException {
        if (defaults == null) {
            defaults = new Properties();
        }
        if (ClickHouseChecker.nonBlank((String)jdbcUrl, (String)"JDBC URL").startsWith(JDBC_CLICKHOUSE_PREFIX)) {
            jdbcUrl = jdbcUrl.substring(JDBC_CLICKHOUSE_PREFIX.length());
        } else if (jdbcUrl.startsWith(JDBC_ABBREVIATION_PREFIX)) {
            jdbcUrl = jdbcUrl.substring(JDBC_ABBREVIATION_PREFIX.length());
        } else {
            throw new URISyntaxException(jdbcUrl, ClickHouseUtils.format((String)"'%s' or '%s' prefix is mandatory", (Object[])new Object[]{JDBC_CLICKHOUSE_PREFIX, JDBC_ABBREVIATION_PREFIX}));
        }
        int index = jdbcUrl.indexOf("//");
        if (index == -1) {
            throw new URISyntaxException(jdbcUrl, "Missing '//' from the given JDBC URL");
        }
        if (index == 0) {
            jdbcUrl = "http:" + jdbcUrl;
        }
        URI uri = new URI(jdbcUrl);
        Properties props = ClickHouseJdbcUrlParser.newProperties();
        props.putAll((Map<?, ?>)defaults);
        ClickHouseJdbcUrlParser.parseParams(uri.getQuery(), props);
        return new ConnectionInfo(uri, ClickHouseJdbcUrlParser.parseNode(uri, props), props);
    }

    private ClickHouseJdbcUrlParser() {
    }

    public static class ConnectionInfo {
        private final URI uri;
        private final ClickHouseNode server;
        private final Properties props;

        protected ConnectionInfo(URI uri, ClickHouseNode server, Properties props) throws URISyntaxException {
            this.uri = new URI(ClickHouseJdbcUrlParser.JDBC_CLICKHOUSE_PREFIX + server.getProtocol().name().toLowerCase(), null, server.getHost(), server.getPort(), "/" + server.getDatabase().orElse(""), ClickHouseJdbcUrlParser.removeCredentialsFromQuery(uri.getRawQuery()), null);
            this.server = server;
            this.props = props;
        }

        public URI getUri() {
            return this.uri;
        }

        public ClickHouseNode getServer() {
            return this.server;
        }

        public Properties getProperties() {
            return this.props;
        }
    }
}

