/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public final class SqlExceptionUtils {
    public static final String SQL_STATE_CLIENT_ERROR = "HY000";
    public static final String SQL_STATE_CONNECTION_EXCEPTION = "08000";
    public static final String SQL_STATE_SQL_ERROR = "07000";
    public static final String SQL_STATE_NO_DATA = "02000";
    public static final String SQL_STATE_INVALID_SCHEMA = "3F000";
    public static final String SQL_STATE_INVALID_TX_STATE = "25000";
    public static final String SQL_STATE_DATA_EXCEPTION = "22000";
    public static final String SQL_STATE_FEATURE_NOT_SUPPORTED = "0A000";

    private SqlExceptionUtils() {
    }

    private static String toSqlState(ClickHouseException e) {
        String sqlState = e.getErrorCode() == 210 || e.getErrorCode() == 1000 ? SQL_STATE_CONNECTION_EXCEPTION : (e.getErrorCode() == 0 ? (e.getCause() instanceof ConnectException ? SQL_STATE_CONNECTION_EXCEPTION : SQL_STATE_CLIENT_ERROR) : (e.getCause() instanceof ConnectException ? SQL_STATE_CONNECTION_EXCEPTION : SQL_STATE_SQL_ERROR));
        return sqlState;
    }

    public static SQLException clientError(String message) {
        return new SQLException(message, SQL_STATE_CLIENT_ERROR, null);
    }

    public static SQLException clientError(Throwable e) {
        return e != null ? new SQLException(e.getMessage(), SQL_STATE_CLIENT_ERROR, e) : SqlExceptionUtils.unknownError();
    }

    public static SQLException clientError(String message, Throwable e) {
        return new SQLException(message, SQL_STATE_CLIENT_ERROR, e);
    }

    public static SQLException handle(ClickHouseException e) {
        return e != null ? new SQLException(e.getMessage(), SqlExceptionUtils.toSqlState(e), e.getErrorCode(), e.getCause()) : SqlExceptionUtils.unknownError();
    }

    public static SQLException handle(Throwable e) {
        if (e == null) {
            return SqlExceptionUtils.unknownError();
        }
        if (e instanceof ClickHouseException) {
            return SqlExceptionUtils.handle((ClickHouseException)e);
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof ClickHouseException) {
            return SqlExceptionUtils.handle((ClickHouseException)cause);
        }
        if (e instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause == null) {
            cause = e;
        }
        return new SQLException(cause);
    }

    public static SQLException forCancellation(Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        return new SQLException(e.getMessage(), "HY008", 236, cause);
    }

    public static SQLFeatureNotSupportedException unsupportedError(String message) {
        return new SQLFeatureNotSupportedException(message, SQL_STATE_FEATURE_NOT_SUPPORTED);
    }

    public static SQLException unknownError() {
        return new SQLException("Unknown error", SQL_STATE_CLIENT_ERROR);
    }
}

