/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.Wrapper;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ClickHouseDataSource
extends Wrapper
implements DataSource {
    private final String url;
    protected final ClickHouseDriver driver = new ClickHouseDriver();
    protected final Properties properties;
    protected final ClickHouseNode server;
    protected final URI uri;
    protected PrintWriter printWriter;
    protected int loginTimeoutSeconds = 0;

    public ClickHouseDataSource(String url) {
        this(url, new Properties());
    }

    public ClickHouseDataSource(String url, Properties properties) {
        if (url == null) {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url. It must be not null");
        }
        this.url = url;
        try {
            ClickHouseJdbcUrlParser.ConnectionInfo connInfo = ClickHouseJdbcUrlParser.parse(url, properties);
            this.properties = connInfo.getProperties();
            this.server = connInfo.getServer();
            this.uri = connInfo.getUri();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        return this.driver.connect(this.url, this.properties);
    }

    @Override
    public ClickHouseConnection getConnection(String username, String password) throws SQLException {
        if (username == null || username.isEmpty()) {
            throw SqlExceptionUtils.clientError("Non-empty user name is required");
        }
        if (password == null) {
            password = "";
        }
        Properties props = new Properties(this.properties);
        props.setProperty(ClickHouseDefaults.USER.getKey(), username);
        props.setProperty(ClickHouseDefaults.PASSWORD.getKey(), password);
        return this.driver.connect(this.url, props);
    }

    public String getHost() {
        return this.server.getHost();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String getDatabase() {
        return this.server.getDatabase().orElse((String)((Object)ClickHouseDefaults.DATABASE.getEffectiveDefaultValue()));
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ClickHouseDriver.parentLogger;
    }
}

