/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseOffsetTimeParser
extends ClickHouseDateValueParser<OffsetTime> {
    private static ClickHouseOffsetTimeParser instance;

    static ClickHouseOffsetTimeParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseOffsetTimeParser();
        }
        return instance;
    }

    private ClickHouseOffsetTimeParser() {
        super(OffsetTime.class);
    }

    @Override
    OffsetTime parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateToZonedDateTime(value, columnInfo, timeZone).toOffsetDateTime().toOffsetTime();
    }

    @Override
    OffsetTime parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateTimeToZonedDateTime(value, columnInfo, timeZone).toOffsetDateTime().toOffsetTime();
    }

    @Override
    OffsetTime parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return OffsetTime.of(this.parseAsLocalTime(value), this.effectiveTimeZone(columnInfo, timeZone).getRules().getOffset(Instant.now()));
    }

    @Override
    OffsetTime parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return OffsetTime.parse(value, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return OffsetTime.of(LocalTime.parse(value, DateTimeFormatter.ISO_LOCAL_TIME), this.effectiveTimeZone(columnInfo, timeZone).getRules().getOffset(Instant.now()));
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return OffsetTime.of(this.parseAsLocalTime(value), this.effectiveTimeZone(columnInfo, timeZone).getRules().getOffset(Instant.now()));
            }
        }
    }
}

