/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseResultSet;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class ClickHouseScrollableResultSet
extends ClickHouseResultSet {
    private List<ByteFragment[]> lines = new ArrayList<ByteFragment[]>();

    public ClickHouseScrollableResultSet(InputStream is, int bufferSize, String db, String table, boolean usesWithTotals, ClickHouseStatement statement, TimeZone timezone, ClickHouseProperties properties) throws IOException {
        super(is, bufferSize, db, table, usesWithTotals, statement, timezone, properties);
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.rowNumber < this.lines.size()) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowNumber < this.lines.size()) {
            this.values = this.lines.get(this.rowNumber);
            this.nextLine = null;
            ++this.rowNumber;
            return true;
        }
        if (this.hasNext()) {
            super.next();
            this.lines.add(this.values);
            return true;
        }
        ++this.rowNumber;
        this.values = null;
        this.nextLine = null;
        return false;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.getRow() > this.lines.size();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(-1);
        this.next();
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row == 0) {
            this.rowNumber = 0;
            this.values = null;
            return false;
        }
        if (row > 0) {
            if (row <= this.lines.size()) {
                this.rowNumber = row;
                this.values = this.lines.get(row - 1);
                return true;
            }
            this.absolute(this.lines.size());
            while (this.getRow() < row && this.hasNext()) {
                this.next();
            }
            if (row == this.getRow()) {
                return true;
            }
            this.next();
            return false;
        }
        while (this.hasNext()) {
            this.next();
        }
        if (-row > this.lines.size()) {
            return this.absolute(0);
        }
        return this.absolute(this.lines.size() + 1 + row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int r = this.getRow() + rows;
        if (r < 0) {
            r = 0;
        }
        return this.absolute(r);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }
}

