/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class LogProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(LogProxy.class);
    private final T object;
    private final Class<T> clazz;

    public static <T> T wrap(Class<T> interfaceClass, T object) {
        Object[] wrapper = (Object[])Array.newInstance(interfaceClass, 1);
        wrapper[0] = object;
        log.trace(() -> {
            LogProxy<Object> proxy = new LogProxy<Object>(interfaceClass, object);
            wrapper[0] = proxy.getProxy();
            return "Proxy enabled for class: " + interfaceClass.getName();
        });
        return (T)wrapper[0];
    }

    private LogProxy(Class<T> interfaceClass, T object) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("Class " + interfaceClass.getName() + " is not an interface");
        }
        this.clazz = interfaceClass;
        this.object = object;
    }

    public T getProxy() {
        return (T)Proxy.newProxyInstance(this.clazz.getClassLoader(), new Class[]{this.clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String msg = "Call class: " + this.object.getClass().getName() + "\nMethod: " + method.getName() + "\nObject: " + this.object + "\nArgs: " + Arrays.toString(args) + "\nInvoke result: ";
        try {
            Object invokeResult = method.invoke(this.object, args);
            msg = msg + invokeResult;
            Object object = invokeResult;
            return object;
        }
        catch (InvocationTargetException e) {
            msg = msg + e.getMessage();
            throw e.getTargetException();
        }
        finally {
            msg = "==== ClickHouse JDBC trace begin ====\n" + msg + "\n==== ClickHouse JDBC trace end ====";
            log.trace((Object)msg, new Object[0]);
        }
    }
}

