/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.metadata;

import com.clickhouse.jdbc.JdbcV2Wrapper;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class ParameterMetaDataImpl
implements ParameterMetaData,
JdbcV2Wrapper {
    private static final int FAIL_SAFE_PRECISION = 0;
    private static final int FAIL_SAFE_SCALE = 0;
    private final int paramCount;

    public ParameterMetaDataImpl(int paramCount) {
        this.paramCount = paramCount;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    private void checkParamIndex(int index) throws SQLException {
        if (index > this.paramCount || index < 1) {
            throw new SQLException("Parameter index out of range. " + (this.paramCount == 0 ? "There are no parameters" : "[1," + this.paramCount + "]"));
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1111;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return "UNKNOWN";
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return Object.class.getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }
}

