/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataStreamFactory;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHousePipedOutputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.ClickHouseResponseHandler;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;

public class HttpClientConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnectionImpl.class);
    private final HttpClient httpClient;
    private final HttpRequest pingRequest;

    private ClickHouseHttpResponse buildResponse(ClickHouseConfig config, HttpResponse<InputStream> r, Runnable postAction) throws IOException {
        Runnable action;
        InputStream source;
        boolean hasOutputFile;
        HttpHeaders headers = r.headers();
        String displayName = headers.firstValue("X-ClickHouse-Server-Display-Name").orElse(this.server.getHost());
        String queryId = headers.firstValue("X-ClickHouse-Query-Id").orElse("");
        String summary = headers.firstValue("X-ClickHouse-Summary").orElse("{}");
        ClickHouseFormat format = config.getFormat();
        TimeZone timeZone = config.getServerTimeZone();
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String value = headers.firstValue("X-ClickHouse-Format").orElse("");
            format = !ClickHouseChecker.isNullOrEmpty(value) ? ClickHouseFormat.valueOf(value) : format;
            value = headers.firstValue("X-ClickHouse-Timezone").orElse("");
            timeZone = !ClickHouseChecker.isNullOrEmpty(value) ? TimeZone.getTimeZone(value) : timeZone;
        }
        boolean bl = hasOutputFile = this.output != null && this.output.getUnderlyingFile().isAvailable();
        if (this.output != null) {
            source = ClickHouseInputStream.empty();
            action = () -> {
                try (ClickHouseOutputStream o = this.output;){
                    ClickHouseInputStream.pipe(this.checkResponse(config, r).body(), (OutputStream)o, config.getWriteBufferSize());
                    if (postAction != null) {
                        postAction.run();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to redirect response to given output stream", e);
                }
                finally {
                    this.closeQuietly();
                }
            };
        } else {
            source = this.checkResponse(config, r).body();
            action = () -> {
                if (postAction != null) {
                    postAction.run();
                }
                this.closeQuietly();
            };
        }
        return new ClickHouseHttpResponse(this, hasOutputFile ? ClickHouseInputStream.of(source, config.getReadBufferSize(), action) : ClickHouseInputStream.wrap(null, source, config.getReadBufferSize(), action, config.getResponseCompressAlgorithm(), config.getResponseCompressLevel()), displayName, queryId, summary, format, timeZone);
    }

    private HttpResponse<InputStream> checkResponse(ClickHouseConfig config, HttpResponse<InputStream> r) throws IOException {
        if (r.statusCode() != 200) {
            String errorMsg;
            String errorCode = r.headers().firstValue("X-ClickHouse-Exception-Code").orElse("");
            String serverName = r.headers().firstValue("X-ClickHouse-Server-Display-Name").orElse("");
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);
            ClickHouseInputStream.pipe(r.body(), (OutputStream)output, bufferSize);
            byte[] bytes = output.toByteArray();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ClickHouseClient.getResponseInputStream(config, new ByteArrayInputStream(bytes), this::closeQuietly), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                while ((errorMsg = reader.readLine()) != null) {
                    builder.append(errorMsg).append('\n');
                }
                errorMsg = builder.toString();
            }
            catch (IOException e) {
                log.debug((Object)"Failed to read error message[code=%s] from server [%s] due to: %s", errorCode, serverName, e.getMessage());
                errorMsg = new String(bytes, StandardCharsets.UTF_8);
            }
            throw new IOException(errorMsg);
        }
        return r;
    }

    private HttpRequest newRequest(String url) {
        return HttpRequest.newBuilder().uri(URI.create(url)).version(HttpClient.Version.HTTP_1_1).timeout(Duration.ofMillis(this.config.getSocketTimeout())).build();
    }

    protected HttpClientConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofMillis(this.config.getConnectionTimeout())).followRedirects(HttpClient.Redirect.NORMAL);
        if (executor != null) {
            builder.executor(executor);
        }
        if (this.config.isUseNoProxy()) {
            builder.proxy(NoProxySelector.INSTANCE);
        }
        if (this.config.isSsl()) {
            builder.sslContext(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null));
        }
        this.httpClient = builder.build();
        this.pingRequest = this.newRequest(this.getBaseUrl() + "ping");
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    private CompletableFuture<HttpResponse<InputStream>> postRequest(HttpRequest request) {
        return this.httpClient.sendAsync(request, responseInfo -> new ClickHouseResponseHandler(this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout()));
    }

    private ClickHouseHttpResponse postStream(ClickHouseConfig config, HttpRequest.Builder reqBuilder, String boundary, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, Runnable postAction) throws IOException {
        HttpResponse<InputStream> r;
        boolean hasFile = data != null && data.getUnderlyingFile().isAvailable();
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, null);
        reqBuilder.POST(HttpRequest.BodyPublishers.ofInputStream(stream::getInputStream));
        CompletableFuture<HttpResponse<InputStream>> f = this.postRequest(reqBuilder.build());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
            if (boundary != null) {
                String line = "\r\n--" + boundary + "\r\n";
                writer.write(line);
                writer.write("Content-Disposition: form-data; name=\"query\"\r\n\r\n");
                writer.write(sql);
                for (ClickHouseExternalTable t : tables) {
                    String tableName = t.getName();
                    StringBuilder builder = new StringBuilder();
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_format\"\r\n\r\n").append(t.getFormat().name());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_structure\"\r\n\r\n").append(t.getStructure());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("\"; filename=\"").append(tableName).append("\"\r\n").append("Content-Type: application/octet-stream\r\n").append("Content-Transfer-Encoding: binary\r\n\r\n");
                    writer.write(builder.toString());
                    writer.flush();
                    ClickHouseInputStream.pipe(t.getContent(), (OutputStream)stream, config.getWriteBufferSize());
                }
                writer.write("\r\n--" + boundary + "--\r\n");
                writer.flush();
            } else {
                if (!hasFile) {
                    writer.write(sql);
                    writer.flush();
                }
                if (data.available() > 0) {
                    if (!hasFile && sql.charAt(sql.length() - 1) != '\n') {
                        stream.write(10);
                    }
                    ClickHouseInputStream.pipe((InputStream)data, (OutputStream)stream, config.getWriteBufferSize());
                }
            }
        }
        try {
            r = f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpConnectTimeoutException) {
                throw new ConnectException(cause.getMessage());
            }
            throw new IOException("Failed to post request", cause);
        }
        return this.buildResponse(config, r, postAction);
    }

    private ClickHouseHttpResponse postString(ClickHouseConfig config, HttpRequest.Builder reqBuilder, String sql, Runnable postAction) throws IOException {
        HttpResponse<InputStream> r;
        reqBuilder.POST(HttpRequest.BodyPublishers.ofString(sql));
        try {
            r = this.postRequest(reqBuilder.build()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpConnectTimeoutException) {
                throw new ConnectException(cause.getMessage());
            }
            throw new IOException("Failed to post query", cause);
        }
        return this.buildResponse(config, r, postAction);
    }

    @Override
    protected ClickHouseHttpResponse post(String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, String url, Map<String, String> headers, ClickHouseConfig config, Runnable postAction) throws IOException {
        ClickHouseConfig c = config == null ? this.config : config;
        HttpRequest.Builder reqBuilder = HttpRequest.newBuilder().uri(URI.create(ClickHouseChecker.isNullOrEmpty(url) ? this.url : url)).timeout(Duration.ofMillis(c.getSocketTimeout()));
        String boundary = null;
        if (tables != null && !tables.isEmpty()) {
            boundary = UUID.randomUUID().toString();
            reqBuilder.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        } else {
            reqBuilder.setHeader("Content-Type", "text/plain; charset=UTF-8");
        }
        headers = this.mergeHeaders(headers);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                reqBuilder.setHeader(header.getKey(), header.getValue());
            }
        }
        return boundary != null || data != null ? this.postStream(c, reqBuilder, boundary, sql, data, tables, postAction) : this.postString(c, reqBuilder, sql, postAction);
    }

    @Override
    public boolean ping(int timeout) {
        String response = (String)((Object)this.config.getOption(ClickHouseHttpOption.DEFAULT_RESPONSE));
        try {
            HttpResponse<String> r = this.httpClient.send(this.pingRequest, HttpResponse.BodyHandlers.ofString());
            return r.statusCode() == 200 && response.equals(r.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            log.debug((Object)"Failed to ping server: %s", e.getMessage());
        }
        return false;
    }

    @Override
    public void close() {
    }

    static class NoProxySelector
    extends ProxySelector {
        static final NoProxySelector INSTANCE = new NoProxySelector();
        private static final List<Proxy> NO_PROXY_LIST = List.of(Proxy.NO_PROXY);

        private NoProxySelector() {
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException e) {
        }

        @Override
        public List<Proxy> select(URI uri) {
            return NO_PROXY_LIST;
        }
    }
}

