/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.grpc.ClickHouseGrpcResponse;
import com.clickhouse.client.grpc.ClickHouseStreamObserver;
import com.clickhouse.client.grpc.impl.QueryInfo;
import com.clickhouse.client.internal.grpc.Context;
import com.clickhouse.client.internal.grpc.Status;
import com.clickhouse.client.internal.grpc.StatusException;
import com.clickhouse.client.internal.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Deprecated
public class ClickHouseGrpcFuture
implements Future<ClickHouseResponse> {
    private final ClickHouseNode server;
    private final ClickHouseRequest<?> request;
    private final StreamObserver<QueryInfo> requestObserver;
    private final ClickHouseStreamObserver responseObserver;

    protected ClickHouseGrpcFuture(ClickHouseNode server, ClickHouseRequest<?> request, StreamObserver<QueryInfo> requestObserver, ClickHouseStreamObserver responseObserver) {
        this.server = ClickHouseChecker.nonNull(server, "server");
        this.request = ClickHouseChecker.nonNull(request, "request").seal();
        this.requestObserver = ClickHouseChecker.nonNull(requestObserver, "requestObserver");
        this.responseObserver = ClickHouseChecker.nonNull(responseObserver, "responseObserver");
    }

    public ClickHouseNode getServer() {
        return this.server;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = true;
        if (mayInterruptIfRunning) {
            cancelled = Context.current().withCancellation().cancel(new StatusException(Status.CANCELLED));
        } else {
            this.requestObserver.onError(new StatusException(Status.CANCELLED));
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.responseObserver.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.responseObserver.isCompleted();
    }

    @Override
    public ClickHouseResponse get() throws InterruptedException, ExecutionException {
        try {
            ClickHouseConfig config = this.request.getConfig();
            return this.get(config.getConnectionTimeout() / 1000 + Math.max(config.getSocketTimeout() / 1000, config.getMaxExecutionTime()), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.cancel(true);
            throw new InterruptedException(e.getMessage());
        }
    }

    @Override
    public ClickHouseResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.responseObserver.await(timeout, unit)) {
            this.cancel(true);
            throw new TimeoutException(ClickHouseUtils.format("Timed out after waiting for %d %s", new Object[]{timeout, unit}));
        }
        try {
            return new ClickHouseGrpcResponse(this.request.getConfig(), this.request.getSettings(), this.responseObserver);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }
}

