/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ByteUtils {
    private final VarHandle byteHandle = MethodHandles.arrayElementVarHandle(byte[].class);
    private final VarHandle shortHandle;
    private final VarHandle intHandle;
    private final VarHandle longHandle;
    private final VarHandle floatHandle;
    private final VarHandle doubleHandle;

    public boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        return Arrays.equals(a, aFromIndex, aToIndex, a, bFromIndex, bToIndex);
    }

    public byte getInt8(byte[] bytes, int offset) {
        return this.byteHandle.get(bytes, offset);
    }

    public void setInt8(byte[] bytes, int offset, byte value) {
        this.byteHandle.set(bytes, offset, value);
    }

    public short getInt16(byte[] bytes, int offset) {
        return this.shortHandle.get(bytes, offset);
    }

    public void setInt16(byte[] bytes, int offset, short value) {
        this.shortHandle.set(bytes, offset, value);
    }

    public int getInt32(byte[] bytes, int offset) {
        return this.intHandle.get(bytes, offset);
    }

    public void setInt32(byte[] bytes, int offset, int value) {
        this.intHandle.set(bytes, offset, value);
    }

    public long getInt64(byte[] bytes, int offset) {
        return this.longHandle.get(bytes, offset);
    }

    public void setInt64(byte[] bytes, int offset, long value) {
        this.longHandle.set(bytes, offset, value);
    }

    public float getFloat32(byte[] bytes, int offset) {
        return this.floatHandle.get(bytes, offset);
    }

    public void setFloat32(byte[] bytes, int offset, float value) {
        this.floatHandle.set(bytes, offset, value);
    }

    public double getFloat64(byte[] bytes, int offset) {
        return this.doubleHandle.get(bytes, offset);
    }

    public void setFloat64(byte[] bytes, int offset, double value) {
        this.doubleHandle.set(bytes, offset, value);
    }

    ByteUtils(ByteOrder byteOrder) {
        this.shortHandle = MethodHandles.byteArrayViewVarHandle(short[].class, byteOrder);
        this.intHandle = MethodHandles.byteArrayViewVarHandle(int[].class, byteOrder);
        this.longHandle = MethodHandles.byteArrayViewVarHandle(long[].class, byteOrder);
        this.floatHandle = MethodHandles.byteArrayViewVarHandle(float[].class, byteOrder);
        this.doubleHandle = MethodHandles.byteArrayViewVarHandle(double[].class, byteOrder);
    }
}

