/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClickHouseFreezableMap<K, V>
implements Map<K, V> {
    private final AtomicBoolean freezed = new AtomicBoolean(false);
    private final Map<K, V> map;
    private final List<K> whitelist;

    public static <K, V> ClickHouseFreezableMap<K, V> of(Map<K, V> map, K ... whiteListedKeys) {
        return new ClickHouseFreezableMap<K, V>(ClickHouseChecker.nonNull(map, "Map"), whiteListedKeys);
    }

    protected ClickHouseFreezableMap(Map<K, V> map, K ... keys) {
        this.map = map;
        if (keys == null || keys.length == 0) {
            this.whitelist = Collections.emptyList();
        } else {
            ArrayList<K> list = new ArrayList<K>(keys.length);
            for (K k : keys) {
                if (k == null || list.contains(k)) continue;
                list.add(k);
            }
            this.whitelist = Collections.unmodifiableList(list);
        }
    }

    protected boolean isMutable(Object key) {
        return !this.freezed.get() || this.whitelist.contains(key);
    }

    @Override
    public void clear() {
        if (this.freezed.get()) {
            for (K k : this.whitelist) {
                this.map.remove(k);
            }
        } else {
            this.map.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.isMutable(key) ? this.map.put(key, value) : value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.freezed.get()) {
            for (K k : this.whitelist) {
                V v = m.get(k);
                if (v == null) continue;
                this.map.put(k, v);
            }
        } else {
            this.map.putAll(m);
        }
    }

    @Override
    public V remove(Object key) {
        return this.isMutable(key) ? (V)this.map.remove(key) : null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public ClickHouseFreezableMap<K, V> freeze() {
        this.freezed.compareAndSet(false, true);
        return this;
    }

    public ClickHouseFreezableMap<K, V> unfreeze() {
        this.freezed.compareAndSet(true, false);
        return this;
    }

    public boolean isFreezed() {
        return this.freezed.get();
    }

    public boolean isWhiteListed(K key) {
        return key != null && this.whitelist.contains(key);
    }
}

