/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value.array;

import com.clickhouse.data.ClickHouseArraySequence;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseBoolArrayValue
extends ClickHouseObjectValue<boolean[]>
implements ClickHouseArraySequence {
    private static final String TYPE_NAME = "boolean[]";

    public static ClickHouseBoolArrayValue ofEmpty() {
        return ClickHouseBoolArrayValue.of(null, ClickHouseValues.EMPTY_BOOL_ARRAY);
    }

    public static ClickHouseBoolArrayValue of(boolean[] value) {
        return ClickHouseBoolArrayValue.of(null, value);
    }

    public static ClickHouseBoolArrayValue of(ClickHouseValue ref, boolean[] value) {
        return ref instanceof ClickHouseBoolArrayValue ? ((ClickHouseBoolArrayValue)ref).set(value) : new ClickHouseBoolArrayValue(value);
    }

    protected ClickHouseBoolArrayValue(boolean[] value) {
        super(value);
    }

    protected final ClickHouseBoolArrayValue set(boolean[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        boolean[] v = (boolean[])this.getValue();
        int len = v.length;
        Object[] array = new Boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        boolean[] v = (boolean[])this.getValue();
        int len = v.length;
        if (clazz == Boolean.class) {
            Boolean[] array = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                array[i] = v[i];
            }
            return array;
        }
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i] ? (byte)1 : 0);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        boolean[] v = (boolean[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString() {
        int len;
        boolean[] value = (boolean[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[').append(value[0]);
        for (int i = 1; i < len; ++i) {
            builder.append(',').append(value[i]);
        }
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseBoolArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseBoolArrayValue((boolean[])this.getValue());
        }
        boolean[] value = (boolean[])this.getValue();
        return new ClickHouseBoolArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public final boolean isNullable() {
        return false;
    }

    @Override
    public final boolean isNullOrEmpty() {
        return ((boolean[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseBoolArrayValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_BOOL_ARRAY);
        return this;
    }

    @Override
    public ClickHouseBoolArrayValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        return this.asString();
    }

    @Override
    public ClickHouseBoolArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            char ch = value[i];
            v[i] = ch == 'Y' || ch == 'y' || ch == '\u0001';
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(byte value) {
        return this.set(new boolean[]{value == 1});
    }

    @Override
    public ClickHouseBoolArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(value);
    }

    @Override
    public ClickHouseBoolArrayValue update(short value) {
        return this.set(new boolean[]{value == 1});
    }

    @Override
    public ClickHouseBoolArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(int value) {
        return this.set(new boolean[]{value == 1});
    }

    @Override
    public ClickHouseBoolArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(long value) {
        return this.set(new boolean[]{value == 1L});
    }

    @Override
    public ClickHouseBoolArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1L;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(float value) {
        return this.set(new boolean[]{value == 1.0f});
    }

    @Override
    public ClickHouseBoolArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1.0f;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(double value) {
        return this.set(new boolean[]{value == 1.0});
    }

    @Override
    public ClickHouseBoolArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] == 1.0;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(BigInteger value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = BigInteger.ONE.equals(value);
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(BigDecimal value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = BigDecimal.ONE.equals(value);
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(Enum<?> value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = value.ordinal() == 1;
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseBoolArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseBoolArrayValue update(LocalDate value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = value.toEpochDay() == 1L;
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(LocalTime value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = value.toSecondOfDay() == 1;
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(LocalDateTime value) {
        boolean[] blArray;
        if (value == null) {
            blArray = ClickHouseValues.EMPTY_BOOL_ARRAY;
        } else {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = value.toEpochSecond(ZoneOffset.UTC) == 1L;
        }
        return this.set(blArray);
    }

    @Override
    public ClickHouseBoolArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o != null && ((Number)o).byteValue() == 1;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        boolean[] values = new boolean[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n != null && n.byteValue() == 1;
        }
        return this.set(values);
    }

    @Override
    public ClickHouseBoolArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        boolean[] v = new boolean[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o != null && ((Number)e.getValue()).byteValue() == 1;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseBoolArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_BOOL_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_BOOL_ARRAY);
            } else {
                boolean[] arr = new boolean[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = v != null && Boolean.parseBoolean(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseBoolArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseBoolArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseBoolArrayValue) {
            this.set((boolean[])((ClickHouseBoolArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseBoolArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Boolean[]) {
            boolean[] values = new boolean[len];
            for (int i = 0; i < len; ++i) {
                values[i] = Boolean.TRUE.equals(value[i]);
            }
            this.set(values);
        } else {
            boolean[] values = new boolean[len];
            for (int i = 0; i < len; ++i) {
                Object o = value[i];
                values[i] = o != null && ((Number)o).byteValue() == 1;
            }
            this.set(values);
        }
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new boolean[]{((Number)value).byteValue() == 1});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseBoolArrayValue update(Object value) {
        if (value instanceof boolean[]) {
            this.set((boolean[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((boolean[])this.getValue(), (boolean[])((ClickHouseBoolArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((boolean[])this.getValue());
    }

    @Override
    public ClickHouseArraySequence allocate(int length, Class<?> clazz, int level) {
        if (length < 1) {
            this.resetToDefault();
        } else if (this.length() != length) {
            this.set(new boolean[length]);
        }
        return this;
    }

    @Override
    public int length() {
        return this.isNullOrEmpty() ? 0 : ((boolean[])this.getValue()).length;
    }

    @Override
    public <V extends ClickHouseValue> V getValue(int index, V value) {
        value.update(((boolean[])this.getValue())[index]);
        return value;
    }

    @Override
    public ClickHouseArraySequence setValue(int index, ClickHouseValue value) {
        ((boolean[])this.getValue())[index] = value.asBoolean();
        return this;
    }
}

