/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDeserializer;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseSerializer;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class ClickHouseDataProcessor {
    public static final List<ClickHouseColumn> DEFAULT_COLUMNS = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected static final String ERROR_FAILED_TO_READ = "Failed to read column #%d of %d: %s";
    protected static final String ERROR_FAILED_TO_WRITE = "Failed to write column #%d of %d: %s";
    protected static final String ERROR_REACHED_END_OF_STREAM = "Reached end of the stream when reading column #%d of %d: %s";
    protected static final String ERROR_UNKNOWN_DATA_TYPE = "Unsupported data type: ";
    protected final ClickHouseDataConfig config;
    protected final ClickHouseInputStream input;
    protected final ClickHouseOutputStream output;
    protected final ClickHouseColumn[] columns;
    protected final ClickHouseRecord currentRecord;
    protected final ClickHouseValue[] templates;
    protected final Map<String, Object> settings;
    protected final Iterator<ClickHouseRecord> records;
    protected final Iterator<ClickHouseValue> values;
    protected final ClickHouseDeserializer[] deserializers;
    protected final ClickHouseSerializer[] serializers;
    protected int readPosition;
    protected int writePosition;

    protected boolean hasMoreToRead() throws UncheckedIOException {
        try {
            if (this.input.available() <= 0) {
                this.input.close();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ClickHouseRecord nextRecord() throws NoSuchElementException, UncheckedIOException {
        ClickHouseRecord r = this.config.isReuseValueWrapper() ? this.currentRecord : this.currentRecord.copy();
        try {
            this.readAndFill(r);
        }
        catch (StreamCorruptedException e) {
            byte[] search = "ode: ".getBytes(StandardCharsets.US_ASCII);
            byte[] bytes = this.input.getBuffer().array();
            int index = ClickHouseUtils.indexOf(bytes, search);
            if (index > 0 && bytes[--index] == 67) {
                throw new UncheckedIOException(new String(bytes, index, bytes.length - index, StandardCharsets.UTF_8), e);
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, this.columns.length, this.columns[this.readPosition]), e);
        }
        catch (EOFException e) {
            if (this.readPosition == 0) {
                throw new NoSuchElementException("No more record");
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_REACHED_END_OF_STREAM, this.readPosition + 1, this.columns.length, this.columns[this.readPosition]), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, this.columns.length, this.columns[this.readPosition]), e);
        }
        return r;
    }

    private ClickHouseValue nextValue() throws NoSuchElementException, UncheckedIOException {
        ClickHouseValue value = this.config.isReuseValueWrapper() ? this.templates[this.readPosition] : this.templates[this.readPosition].copy();
        try {
            this.readAndFill(value);
        }
        catch (EOFException e) {
            if (this.readPosition == 0) {
                throw new NoSuchElementException("No more value");
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_REACHED_END_OF_STREAM, this.readPosition + 1, this.columns.length, this.columns[this.readPosition]), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, this.columns.length, this.columns[this.readPosition]), e);
        }
        return value;
    }

    protected ClickHouseDeserializer[] buildDeserializeSteps(ClickHouseColumn column) {
        return new ClickHouseDeserializer[0];
    }

    protected ClickHouseSerializer[] buildSerializeSteps(ClickHouseColumn column) {
        return new ClickHouseSerializer[0];
    }

    protected abstract ClickHouseRecord createRecord();

    protected Iterator<ClickHouseRecord> initRecords() {
        if (this.readPosition != 0) {
            throw new IllegalStateException("initRecords() is supposed to be called once during instantiation");
        }
        return new RecordsIterator(this);
    }

    protected Iterator<ClickHouseValue> initValues() {
        if (this.readPosition != 0) {
            throw new IllegalStateException("initValues() is supposed to be called once during instantiation");
        }
        return new ValuesIterator(this);
    }

    protected void readAndFill(ClickHouseRecord r) throws IOException {
        int i = this.readPosition;
        int len = this.columns.length;
        while (i < len) {
            this.readAndFill(r.getValue(i));
            this.readPosition = i++;
        }
        this.readPosition = 0;
    }

    protected void readAndFill(ClickHouseValue value) throws IOException {
        int pos = this.readPosition;
        ClickHouseValue v = this.deserializers[pos].deserialize(value, this.input);
        if (v != value) {
            this.templates[pos] = v;
        }
        this.readPosition = ++pos >= this.columns.length ? 0 : pos;
    }

    protected abstract List<ClickHouseColumn> readColumns() throws IOException;

    protected ClickHouseDataProcessor(ClickHouseDataConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, List<ClickHouseColumn> columns, Map<String, Serializable> settings) throws IOException {
        int i;
        this.config = ClickHouseChecker.nonNull(config, "DataConfig");
        if (input == null && output == null) {
            throw new IllegalArgumentException("One of input and output stream must not be null");
        }
        this.input = input;
        this.output = output;
        this.settings = settings == null || settings.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Serializable>(settings));
        if (columns == null && input != null) {
            columns = this.readColumns();
        }
        int colCount = 0;
        if (columns == null || columns.isEmpty()) {
            this.columns = ClickHouseColumn.EMPTY_ARRAY;
            this.templates = ClickHouseValues.EMPTY_VALUES;
        } else {
            colCount = columns.size();
            int idx = 0;
            this.columns = new ClickHouseColumn[colCount];
            this.templates = new ClickHouseValue[colCount];
            for (ClickHouseColumn column : columns) {
                column.setColumnIndex(idx, colCount);
                this.columns[idx] = column;
                this.templates[idx] = column.newValue(config);
                ++idx;
            }
        }
        if (input == null) {
            this.currentRecord = ClickHouseRecord.EMPTY;
            this.records = Collections.emptyIterator();
            this.values = Collections.emptyIterator();
            this.deserializers = new ClickHouseDeserializer[0];
            this.serializers = new ClickHouseSerializer[colCount];
            for (i = 0; i < colCount; ++i) {
                this.serializers[i] = this.getSerializer(config, this.columns[i]);
            }
        } else {
            this.currentRecord = this.createRecord();
            this.records = ClickHouseChecker.nonNull(this.initRecords(), "Records");
            this.values = ClickHouseChecker.nonNull(this.initValues(), "Values");
            this.deserializers = new ClickHouseDeserializer[colCount];
            this.serializers = new ClickHouseSerializer[0];
            for (i = 0; i < colCount; ++i) {
                this.deserializers[i] = this.getDeserializer(config, this.columns[i]);
            }
        }
        this.readPosition = 0;
        this.writePosition = 0;
    }

    public abstract ClickHouseDeserializer getDeserializer(ClickHouseDataConfig var1, ClickHouseColumn var2);

    public final ClickHouseDeserializer[] getDeserializers(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        ArrayList<ClickHouseDeserializer> list = new ArrayList<ClickHouseDeserializer>(columns.size());
        for (ClickHouseColumn column : columns) {
            list.add(this.getDeserializer(config, column));
        }
        return list.toArray(new ClickHouseDeserializer[0]);
    }

    public abstract ClickHouseSerializer getSerializer(ClickHouseDataConfig var1, ClickHouseColumn var2);

    public final ClickHouseSerializer[] getSerializers(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        ArrayList<ClickHouseSerializer> list = new ArrayList<ClickHouseSerializer>(columns.size());
        for (ClickHouseColumn column : columns) {
            list.add(this.getSerializer(config, column));
        }
        return list.toArray(new ClickHouseSerializer[0]);
    }

    public final List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(Arrays.asList(this.columns));
    }

    public final Iterable<ClickHouseRecord> records() {
        return () -> this.records;
    }

    public final Iterable<ClickHouseValue> values() {
        if (this.columns.length == 0) {
            return Collections.emptyList();
        }
        return () -> this.values;
    }

    public ClickHouseValue read(ClickHouseValue value) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("No input stream available to read");
        }
        int len = this.columns.length;
        int pos = this.readPosition;
        if (len == 0 || pos >= len) {
            throw new IllegalStateException(ClickHouseUtils.format("No column to read(total=%d, readPosition=%d)", len, pos));
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? this.templates[pos] : this.templates[pos].copy();
        }
        this.readAndFill(value);
        return value;
    }

    public void write(ClickHouseValue value) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("No output stream available to write");
        }
        int len = this.columns.length;
        int pos = this.writePosition;
        if (len == 0 || pos >= len) {
            throw new IllegalStateException(ClickHouseUtils.format("No column to write(total=%d, writePosition=%d)", len, pos));
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? this.templates[pos] : this.templates[pos].copy();
        }
        this.serializers[pos++].serialize(value, this.output);
        this.writePosition = pos >= len ? 0 : pos;
    }

    static final class RecordsIterator
    implements Iterator<ClickHouseRecord> {
        private final ClickHouseDataProcessor processor;

        RecordsIterator(ClickHouseDataProcessor processor) {
            this.processor = processor;
        }

        @Override
        public boolean hasNext() {
            return this.processor.hasMoreToRead();
        }

        @Override
        public ClickHouseRecord next() {
            return this.processor.nextRecord();
        }
    }

    static final class ValuesIterator
    implements Iterator<ClickHouseValue> {
        private final ClickHouseDataProcessor processor;

        ValuesIterator(ClickHouseDataProcessor processor) {
            this.processor = processor;
        }

        @Override
        public boolean hasNext() {
            return this.processor.hasMoreToRead();
        }

        @Override
        public ClickHouseValue next() {
            return this.processor.nextValue();
        }
    }

    protected static final class UseObjectConfig
    extends ClickHouseDataConfig.Wrapped {
        public UseObjectConfig(ClickHouseDataConfig config) {
            super(config);
        }

        @Override
        public boolean isUseObjectsInArray() {
            return true;
        }
    }
}

