/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ClickHouseByteBuffer
implements Serializable {
    private static final long serialVersionUID = -8178041799873465082L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES).asReadOnlyBuffer();
    protected byte[] array;
    protected int position;
    protected int length;

    public static ClickHouseByteBuffer newInstance() {
        return new ClickHouseByteBuffer(EMPTY_BYTES, 0, 0);
    }

    public static ClickHouseByteBuffer of(ByteBuffer buffer) {
        byte[] bytes;
        if (buffer == null || !buffer.hasRemaining()) {
            return ClickHouseByteBuffer.newInstance();
        }
        int pos = buffer.position();
        int len = buffer.remaining();
        if (buffer.hasArray()) {
            bytes = buffer.array();
        } else {
            bytes = new byte[len];
            buffer.get(bytes);
            ((Buffer)buffer).position(pos);
            pos = 0;
        }
        return new ClickHouseByteBuffer(bytes, pos, len);
    }

    public static ClickHouseByteBuffer of(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? ClickHouseByteBuffer.newInstance() : new ClickHouseByteBuffer(bytes, 0, bytes.length);
    }

    public static ClickHouseByteBuffer of(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return ClickHouseByteBuffer.newInstance();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        return new ClickHouseByteBuffer(bytes, offset, length);
    }

    public static ClickHouseByteBuffer of(List<byte[]> list, int offset, int length) {
        ClickHouseByteBuffer buf = ClickHouseByteBuffer.newInstance();
        if (list == null || list.isEmpty() || length == 0) {
            return buf;
        }
        return buf.update(list, offset, length);
    }

    static void validate(byte[] bytes, int offset, int length) {
        int len = ClickHouseChecker.nonNull(bytes, "Byte array").length;
        if (ClickHouseChecker.between(offset, "Offset", 0, len) + ClickHouseChecker.between(length, "Length", 0, len) > len) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Offset(%d) plus length(%d) should not greater than %d", offset, length, len));
        }
    }

    protected ClickHouseByteBuffer(byte[] bytes, int offset, int length) {
        this.array = bytes;
        this.position = offset;
        this.length = length;
    }

    public BigInteger asBigInteger() {
        return this.getBigInteger(0, this.length, false);
    }

    public boolean asBoolean() {
        return this.getBoolean(0);
    }

    public boolean[] asBooleanArray() {
        int len = this.length;
        boolean[] values = new boolean[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.array[this.position + i] == 1;
        }
        return values;
    }

    public double asDouble() {
        return this.getDouble(0);
    }

    public double[] asDoubleArray() {
        int step = 8;
        int len = this.length / step;
        double[] values = new double[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getDouble(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public float asFloat() {
        return this.getFloat(0);
    }

    public float[] asFloatArray() {
        int step = 4;
        int len = this.length / step;
        float[] values = new float[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getFloat(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public BigInteger asUnsignedBigInteger() {
        return this.getBigInteger(0, this.length, true);
    }

    public BigInteger getBigInteger(int offset, int byteLength, boolean unsigned) {
        byte[] bytes = new byte[byteLength];
        int startIndex = offset + this.position;
        int i = startIndex + byteLength - 1;
        int j = 0;
        while (i >= startIndex) {
            bytes[j] = this.array[i];
            --i;
            ++j;
        }
        return unsigned ? new BigInteger(1, bytes) : new BigInteger(bytes);
    }

    public boolean getBoolean(int offset) {
        return this.array[offset + this.position] == 1;
    }

    public double getDouble(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInteger(offset));
    }

    public int getInteger(int offset) {
        int i = offset + this.position;
        return 0xFF & this.array[i] | (0xFF & this.array[i + 1]) << 8 | (0xFF & this.array[i + 2]) << 16 | (0xFF & this.array[i + 3]) << 24;
    }

    public long getLong(int offset) {
        int i = offset + this.position;
        return 0xFFL & (long)this.array[i] | (0xFFL & (long)this.array[i + 1]) << 8 | (0xFFL & (long)this.array[i + 2]) << 16 | (0xFFL & (long)this.array[i + 3]) << 24 | (0xFFL & (long)this.array[i + 4]) << 32 | (0xFFL & (long)this.array[i + 5]) << 40 | (0xFFL & (long)this.array[i + 6]) << 48 | (0xFFL & (long)this.array[i + 7]) << 56;
    }

    public short getShort(int offset) {
        int i = offset + this.position;
        return (short)(0xFF & this.array[i] | this.array[i + 1] << 8);
    }

    public long getUnsignedInteger(int offset) {
        return 0xFFFFFFFFL & (long)this.getInteger(offset);
    }

    public BigInteger getUnsignedLong(int offset) {
        return this.getBigInteger(0, 8, true);
    }

    public int getUnsignedShort(int offset) {
        return 0xFFFF & this.getShort(offset);
    }

    public BigInteger[] asBigIntegerArray(int byteLength, boolean unsigned) {
        int len = this.length / byteLength;
        BigInteger[] values = new BigInteger[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getBigInteger(offset, byteLength, unsigned);
            ++i;
            offset += byteLength;
        }
        return values;
    }

    public int asInteger() {
        return this.getInteger(0);
    }

    public long asLong() {
        return this.getLong(0);
    }

    public short asShort() {
        return this.getShort(0);
    }

    public int[] asIntegerArray() {
        int step = 4;
        int len = this.length / step;
        int[] values = new int[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getInteger(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public long[] asLongArray() {
        int step = 8;
        int len = this.length / step;
        long[] values = new long[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getLong(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public short[] asShortArray() {
        int step = 2;
        int len = this.length / step;
        short[] values = new short[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getShort(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public long asUnsignedInteger() {
        return this.getUnsignedInteger(0);
    }

    public BigInteger asUnsignedLong() {
        return this.getUnsignedLong(0);
    }

    public int asUnsignedShort() {
        return this.getUnsignedShort(0);
    }

    public long[] asUnsignedIntegerArray() {
        int step = 4;
        int len = this.length / step;
        long[] values = new long[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getUnsignedInteger(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public int[] asUnsignedShortArray() {
        int step = 2;
        int len = this.length / step;
        int[] values = new int[len];
        int i = 0;
        int offset = 0;
        while (i < len) {
            values[i] = this.getUnsignedShort(offset);
            ++i;
            offset += step;
        }
        return values;
    }

    public UUID asUuid() {
        return this.getUuid(0);
    }

    public UUID getUuid(int offset) {
        return new UUID(this.getLong(offset), this.getLong(offset + 8));
    }

    public String asAsciiString() {
        return this.asString(StandardCharsets.US_ASCII);
    }

    public String asString(Charset charset) {
        if (this.length < 1) {
            return "";
        }
        return new String(this.array, this.position, this.length, charset != null ? charset : StandardCharsets.UTF_8);
    }

    public String asUnicodeString() {
        return this.asString(StandardCharsets.UTF_8);
    }

    public ClickHouseByteBuffer compact() {
        if (this.position > 0 || this.length < this.array.length) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(this.array, this.position, bytes, 0, this.length);
            this.array = bytes;
            this.position = 0;
        }
        return this;
    }

    public boolean isCompact() {
        return this.position == 0 && this.array.length == this.length;
    }

    public boolean isEmpty() {
        return this.length < 1;
    }

    public boolean match(byte[] bytes) {
        int len;
        boolean matched = false;
        int n = len = bytes == null ? 0 : bytes.length;
        if (len == this.length) {
            matched = true;
            for (int i = 0; i < len; ++i) {
                if (bytes[i] == this.array[this.position + i]) continue;
                matched = false;
                break;
            }
        }
        return matched;
    }

    public ClickHouseByteBuffer reset() {
        this.array = EMPTY_BYTES;
        this.position = 0;
        this.length = 0;
        return this;
    }

    public ClickHouseByteBuffer reverse() {
        return this.reverse(0, this.length);
    }

    public ClickHouseByteBuffer reverse(int offset, int length) {
        if (length > 1) {
            int i;
            int l = (offset += this.position) + length;
            int len = i + length / 2;
            for (i = offset; i < len; ++i) {
                byte b = this.array[i];
                this.array[i] = this.array[--l];
                this.array[l] = b;
            }
        }
        return this;
    }

    public ClickHouseByteBuffer slice(int offset, int length) {
        if (offset == 0 && length == this.length) {
            return this;
        }
        return ClickHouseByteBuffer.of(this.array, offset + this.position, length);
    }

    public ClickHouseByteBuffer update(ByteBuffer buffer) {
        byte[] bytes;
        if (buffer == null || !buffer.hasRemaining()) {
            return this.reset();
        }
        int pos = buffer.position();
        int len = buffer.remaining();
        if (buffer.hasArray()) {
            bytes = buffer.array();
        } else {
            bytes = new byte[len];
            buffer.get(bytes);
            ((Buffer)buffer).position(pos);
            pos = 0;
        }
        return this.update(bytes, pos, len);
    }

    public ClickHouseByteBuffer update(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.reset();
        } else {
            this.position = 0;
            this.array = bytes;
            this.length = bytes.length;
        }
        return this;
    }

    public ClickHouseByteBuffer update(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return this.reset();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        if (bytes != this.array) {
            this.array = bytes;
        }
        this.position = offset;
        this.length = length;
        return this;
    }

    public ClickHouseByteBuffer update(List<byte[]> list, int offset, int length) {
        if (list == null || list.isEmpty() || length == 0) {
            return this.reset();
        }
        if (list.size() == 1) {
            return this.update(list.get(0), offset, length);
        }
        byte[][] bb = new byte[list.size()][];
        int limit = offset + length;
        int len = 0;
        int index = 0;
        int startIndex = -1;
        int startOffset = -1;
        int endIndex = -1;
        int endOffset = -1;
        for (byte[] bytes : list) {
            if (startIndex < 0 && (len += ClickHouseChecker.nonNull(bytes, "Byte array").length) > offset) {
                startIndex = index;
                startOffset = offset - (len - bytes.length);
            }
            if (endIndex < 0 && len >= limit) {
                endIndex = index;
                endOffset = limit - (len - bytes.length);
            }
            bb[index++] = bytes;
        }
        if (ClickHouseChecker.between(offset, "Offset", 0, len) + ClickHouseChecker.between(length, "Length", 0, len) > len) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Offset(%d) plus length(%d) should not greater than %d", offset, length, len));
        }
        if (startIndex == endIndex) {
            this.array = bb[startIndex];
            this.position = startOffset;
            this.length = length;
        } else {
            this.array = new byte[length];
            byte[] bytes = bb[startIndex];
            System.arraycopy(bytes, startOffset, this.array, 0, bytes.length - startOffset);
            startOffset = bytes.length - startOffset;
            for (int i = startIndex + 1; i < endIndex; ++i) {
                bytes = bb[i];
                System.arraycopy(bytes, 0, this.array, startOffset, bytes.length);
                startOffset += bytes.length;
            }
            bytes = bb[endIndex];
            System.arraycopy(bytes, 0, this.array, startOffset, endOffset);
            this.position = 0;
            this.length = length;
        }
        return this;
    }

    public byte[] array() {
        return this.array;
    }

    public ClickHouseByteBuffer copy(boolean deep) {
        int pos;
        byte[] bytes;
        if (deep) {
            bytes = new byte[this.length];
            pos = 0;
            System.arraycopy(this.array, this.position, bytes, 0, this.length);
        } else {
            bytes = this.array;
            pos = this.position;
        }
        return ClickHouseByteBuffer.of(bytes, pos, this.length);
    }

    public byte firstByte() {
        return this.array[this.position];
    }

    public byte getByte(int offset) {
        return this.array[this.position + ClickHouseChecker.between(offset, "Offset", 0, this.length)];
    }

    public byte lastByte() {
        return this.array[this.position + this.length - 1];
    }

    public int position() {
        return this.position;
    }

    public ClickHouseByteBuffer position(int newPosition) {
        this.position = newPosition;
        return this;
    }

    public int length() {
        return this.length;
    }

    public int limit() {
        return this.position + this.length;
    }

    public void setLength(int newLength) {
        this.length = ClickHouseChecker.between(newLength, "Length", 0, this.array.length - this.position);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.array);
        result = 31 * result + this.position;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseByteBuffer other = (ClickHouseByteBuffer)obj;
        return Arrays.equals(this.array, other.array) && this.position == other.position && this.length == other.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "array=" + this.array + ", position=" + this.position + ", length=" + this.length + ')';
    }
}

