/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.UnsignedInteger;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ClickHouseIntegerValue
implements ClickHouseValue {
    private boolean isNull;
    private int value;

    public static ClickHouseIntegerValue ofNull() {
        return ClickHouseIntegerValue.ofNull(null, false);
    }

    public static ClickHouseIntegerValue ofUnsignedNull() {
        return ClickHouseIntegerValue.ofNull(null, true);
    }

    public static ClickHouseIntegerValue ofNull(boolean unsigned) {
        return ClickHouseIntegerValue.ofNull(null, unsigned);
    }

    public static ClickHouseIntegerValue ofNull(ClickHouseValue ref, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedIntegerValue ? ((UnsignedIntegerValue)ref).set(true, 0) : new UnsignedIntegerValue(true, 0);
        }
        return ref instanceof ClickHouseIntegerValue ? ((ClickHouseIntegerValue)ref).set(true, 0) : new ClickHouseIntegerValue(true, 0);
    }

    public static ClickHouseIntegerValue of(int value) {
        return ClickHouseIntegerValue.of(null, value, false);
    }

    public static ClickHouseIntegerValue ofUnsigned(int value) {
        return ClickHouseIntegerValue.of(null, value, true);
    }

    public static ClickHouseIntegerValue of(int value, boolean unsigned) {
        return ClickHouseIntegerValue.of(null, value, unsigned);
    }

    public static ClickHouseIntegerValue of(Number value, boolean unsigned) {
        return value == null ? ClickHouseIntegerValue.ofNull(null, unsigned) : ClickHouseIntegerValue.of(null, value.intValue(), unsigned);
    }

    public static ClickHouseIntegerValue of(ClickHouseValue ref, int value, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedIntegerValue ? ((UnsignedIntegerValue)ref).set(false, value) : new UnsignedIntegerValue(false, value);
        }
        return ref instanceof ClickHouseIntegerValue ? ((ClickHouseIntegerValue)ref).set(false, value) : new ClickHouseIntegerValue(false, value);
    }

    protected ClickHouseIntegerValue(boolean isNull, int value) {
        this.set(isNull, value);
    }

    protected final ClickHouseIntegerValue set(boolean isNull, int value) {
        this.isNull = isNull;
        this.value = isNull ? 0 : value;
        return this;
    }

    public final int getValue() {
        return this.value;
    }

    @Override
    public ClickHouseIntegerValue copy(boolean deep) {
        return new ClickHouseIntegerValue(this.isNull, this.value);
    }

    @Override
    public final boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Integer.valueOf(this.getValue());
    }

    @Override
    public String asString() {
        return this.isNull ? null : Integer.toString(this.value);
    }

    @Override
    public ClickHouseIntegerValue resetToDefault() {
        return this.set(false, 0);
    }

    @Override
    public ClickHouseIntegerValue resetToNullOrEmpty() {
        return this.set(true, 0);
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : Integer.toString(this.value);
    }

    @Override
    public ClickHouseIntegerValue update(boolean value) {
        return this.set(false, value ? 1 : 0);
    }

    @Override
    public ClickHouseIntegerValue update(char value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseIntegerValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseIntegerValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseIntegerValue update(int value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseIntegerValue update(long value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseIntegerValue update(float value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseIntegerValue update(double value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseIntegerValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValueExact());
    }

    @Override
    public ClickHouseIntegerValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValueExact());
    }

    @Override
    public ClickHouseIntegerValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal());
    }

    @Override
    public ClickHouseIntegerValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Integer.parseInt(value));
    }

    @Override
    public ClickHouseIntegerValue update(ClickHouseValue value) {
        return value == null || value.isNullOrEmpty() ? this.resetToNullOrEmpty() : this.set(false, value.asInteger());
    }

    @Override
    public ClickHouseIntegerValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).intValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asInteger());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseIntegerValue v = (ClickHouseIntegerValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + this.value;
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }

    static final class UnsignedIntegerValue
    extends ClickHouseIntegerValue {
        protected UnsignedIntegerValue(boolean isNull, int value) {
            super(isNull, value);
        }

        @Override
        public long asLong() {
            return 0xFFFFFFFFL & (long)this.getValue();
        }

        @Override
        public BigInteger asBigInteger() {
            return this.isNullOrEmpty() ? null : BigInteger.valueOf(this.asLong());
        }

        @Override
        public float asFloat() {
            return this.asLong();
        }

        @Override
        public double asDouble() {
            return this.asLong();
        }

        @Override
        public BigDecimal asBigDecimal(int scale) {
            return this.isNullOrEmpty() ? null : BigDecimal.valueOf(this.asLong(), scale);
        }

        @Override
        public Object asObject() {
            return this.isNullOrEmpty() ? null : UnsignedInteger.valueOf(this.getValue());
        }

        @Override
        public String asString() {
            return this.isNullOrEmpty() ? null : Integer.toUnsignedString(this.getValue());
        }

        @Override
        public ClickHouseIntegerValue copy(boolean deep) {
            return new UnsignedIntegerValue(this.isNullOrEmpty(), this.getValue());
        }

        @Override
        public String toSqlExpression() {
            return this.isNullOrEmpty() ? "NULL" : Integer.toUnsignedString(this.getValue());
        }

        @Override
        public ClickHouseIntegerValue update(byte value) {
            return this.set(false, 0xFF & value);
        }

        @Override
        public ClickHouseIntegerValue update(short value) {
            return this.set(false, 0xFFFF & value);
        }

        @Override
        public ClickHouseIntegerValue update(BigInteger value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValue());
        }

        @Override
        public ClickHouseIntegerValue update(BigDecimal value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValue());
        }

        @Override
        public ClickHouseIntegerValue update(String value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, Integer.parseUnsignedInt(value));
        }
    }
}

